/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AdditionSubtractionExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LiteralValue;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;

public final class AdditionExpression
extends AdditionSubtractionExpression {
    private static final long serialVersionUID = -971366486450425605L;
    private static final Logger logger = LoggerFactory.getLogger(AdditionExpression.class);

    public AdditionExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation("+");
    }

    static Object executeAddition(IExpressionContext context, AdditionExpression expression, StandardExpressionExecutionContext expContext) {
        BigDecimal rightNumberValue;
        BigDecimal leftNumberValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating addition expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        IStandardVariableExpressionEvaluator expressionEvaluator = StandardExpressions.getVariableExpressionEvaluator(context.getConfiguration());
        IStandardExpression leftExpr = expression.getLeft();
        IStandardExpression rightExpr = expression.getRight();
        Object leftValue = leftExpr instanceof Expression ? Expression.execute(context, (Expression)leftExpr, expressionEvaluator, expContext) : leftExpr.execute(context, expContext);
        Object rightValue = rightExpr instanceof Expression ? Expression.execute(context, (Expression)rightExpr, expressionEvaluator, expContext) : rightExpr.execute(context, expContext);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        if ((leftNumberValue = EvaluationUtils.evaluateAsNumber(leftValue)) != null && (rightNumberValue = EvaluationUtils.evaluateAsNumber(rightValue)) != null) {
            return leftNumberValue.add(rightNumberValue);
        }
        return new LiteralValue(LiteralValue.unwrap(leftValue).toString() + LiteralValue.unwrap(rightValue).toString());
    }
}

