/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.BooleanTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingState;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Token;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;

public final class AndExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -6085038102412415337L;
    private static final Logger logger = LoggerFactory.getLogger(AndExpression.class);
    private static final String OPERATOR = "and";
    static final String[] OPERATORS = new String[]{"and"};
    private static final boolean[] LENIENCIES = new boolean[]{false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{AndExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    public AndExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(OPERATOR);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof BooleanTokenExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof BooleanTokenExpression);
    }

    static ExpressionParsingState composeAndExpression(ExpressionParsingState state, int nodeIndex) {
        return AndExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static Object executeAnd(IExpressionContext context, AndExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue;
        boolean leftBooleanValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating AND expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (!(leftBooleanValue = EvaluationUtils.evaluateAsBoolean(leftValue = expression.getLeft().execute(context, expContext)))) {
            return Boolean.FALSE;
        }
        Object rightValue = expression.getRight().execute(context, expContext);
        boolean rightBooleanValue = EvaluationUtils.evaluateAsBoolean(rightValue);
        return rightBooleanValue;
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = AndExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = AndExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

