/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ComplexExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingState;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class DefaultExpression
extends ComplexExpression {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpression.class);
    private static final long serialVersionUID = 1830867943963082362L;
    private static final String OPERATOR = "?:";
    static final String[] OPERATORS = new String[]{String.valueOf("?:")};
    private final Expression queriedExpression;
    private final Expression defaultExpression;

    public DefaultExpression(Expression queriedExpression, Expression defaultExpression) {
        Validate.notNull(queriedExpression, "Queried expression cannot be null");
        Validate.notNull(defaultExpression, "Default expression cannot be null");
        this.queriedExpression = queriedExpression;
        this.defaultExpression = defaultExpression;
    }

    public Expression getQueriedExpression() {
        return this.queriedExpression;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.queriedExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.queriedExpression);
            sb.append(')');
        } else {
            sb.append(this.queriedExpression);
        }
        sb.append(' ');
        sb.append(OPERATOR);
        sb.append(' ');
        if (this.defaultExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.defaultExpression);
            sb.append(')');
        } else {
            sb.append(this.defaultExpression);
        }
        return sb.toString();
    }

    static ExpressionParsingState composeDefaultExpression(ExpressionParsingState state, int nodeIndex) {
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int defaultOperatorPos = input.indexOf(OPERATOR);
        if (defaultOperatorPos == -1) {
            return state;
        }
        String queriedStr = input.substring(0, defaultOperatorPos);
        String defaultStr = input.substring(defaultOperatorPos + 2);
        if (defaultStr.contains(OPERATOR)) {
            return null;
        }
        Expression queriedExpr = ExpressionParsingUtil.parseAndCompose(state, queriedStr);
        if (queriedExpr == null) {
            return null;
        }
        Expression defaultExpr = ExpressionParsingUtil.parseAndCompose(state, defaultStr);
        if (defaultExpr == null) {
            return null;
        }
        DefaultExpression defaultExpressionResult = new DefaultExpression(queriedExpr, defaultExpr);
        state.setNode(nodeIndex, defaultExpressionResult);
        return state;
    }

    static Object executeDefault(IExpressionContext context, DefaultExpression expression, StandardExpressionExecutionContext expContext) {
        Object queriedValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating default expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if ((queriedValue = expression.getQueriedExpression().execute(context, expContext)) == null) {
            return expression.getDefaultExpression().execute(context, expContext);
        }
        return queriedValue;
    }
}

