/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.cache.ExpressionCacheKey;
import org.ezlibs.shaded.org.thymeleaf.cache.ICache;
import org.ezlibs.shaded.org.thymeleaf.cache.ICacheManager;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AssignationSequence;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Each;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionSequence;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentSignature;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;

final class ExpressionCache {
    private static final String EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION = "expr";
    private static final String EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE = "aseq";
    private static final String EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE = "eseq";
    private static final String EXPRESSION_CACHE_TYPE_EACH = "each";
    private static final String EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE = "fsig";

    private ExpressionCache() {
    }

    static Object getFromCache(IEngineConfiguration configuration, String input, String type) {
        ICache<ExpressionCacheKey, Object> cache;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            return cache.get(new ExpressionCacheKey(type, input));
        }
        return null;
    }

    static <V> void putIntoCache(IEngineConfiguration configuration, String input, V value, String type) {
        ICache<ExpressionCacheKey, Object> cache;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            cache.put(new ExpressionCacheKey(type, input), value);
        }
    }

    static <V> void removeFromCache(IEngineConfiguration configuration, String input, String type) {
        ICache<ExpressionCacheKey, Object> cache;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            cache.clearKey(new ExpressionCacheKey(type, input));
        }
    }

    static IStandardExpression getExpressionFromCache(IEngineConfiguration configuration, String input) {
        return (IStandardExpression)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION);
    }

    static void putExpressionIntoCache(IEngineConfiguration configuration, String input, IStandardExpression value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_TYPE_STANDARD_EXPRESSION);
    }

    static AssignationSequence getAssignationSequenceFromCache(IEngineConfiguration configuration, String input) {
        return (AssignationSequence)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE);
    }

    static void putAssignationSequenceIntoCache(IEngineConfiguration configuration, String input, AssignationSequence value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_TYPE_ASSIGNATION_SEQUENCE);
    }

    static ExpressionSequence getExpressionSequenceFromCache(IEngineConfiguration configuration, String input) {
        return (ExpressionSequence)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE);
    }

    static void putExpressionSequenceIntoCache(IEngineConfiguration configuration, String input, ExpressionSequence value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_TYPE_EXPRESSION_SEQUENCE);
    }

    static Each getEachFromCache(IEngineConfiguration configuration, String input) {
        return (Each)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_EACH);
    }

    static void putEachIntoCache(IEngineConfiguration configuration, String input, Each value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_TYPE_EACH);
    }

    static FragmentSignature getFragmentSignatureFromCache(IEngineConfiguration configuration, String input) {
        return (FragmentSignature)ExpressionCache.getFromCache(configuration, input, EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE);
    }

    static void putFragmentSignatureIntoCache(IEngineConfiguration configuration, String input, FragmentSignature value) {
        ExpressionCache.putIntoCache(configuration, input, value, EXPRESSION_CACHE_TYPE_FRAGMENT_SIGNATURE);
    }
}

