/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AdditionSubtractionExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AndExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.BooleanTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ConditionalExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.DefaultExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingState;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.GenericTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.GreaterLesserExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LinkExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LiteralSubstitutionUtil;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MessageExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MinusExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MultiplicationDivisionRemainderExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NegationExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NullTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NumberTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.OrExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.SimpleExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.TextLiteralExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Token;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.VariableExpression;
import org.ezlibs.shaded.org.thymeleaf.util.ArrayUtils;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

final class ExpressionParsingUtil {
    private static final String[] PROTECTED_TOKENS;

    public static ExpressionParsingState decompose(String input) {
        ExpressionParsingState state = ExpressionParsingUtil.decomposeSimpleExpressions(LiteralSubstitutionUtil.performLiteralSubstitution(input));
        return ExpressionParsingUtil.decomposeNestingParenthesis(state, 0);
    }

    private static ExpressionParsingState decomposeSimpleExpressions(String input) {
        if (input == null) {
            return null;
        }
        ExpressionParsingState state = new ExpressionParsingState();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            state.addNode(input);
            return state;
        }
        StringBuilder decomposedInput = new StringBuilder(24);
        StringBuilder currentFragment = new StringBuilder(24);
        int currentIndex = 1;
        int expLevel = 0;
        boolean inLiteral = false;
        boolean inToken = false;
        boolean inNothing = true;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            if (inToken && !Token.isTokenChar(input, i)) {
                if (ExpressionParsingUtil.finishCurrentToken(currentIndex, state, decomposedInput, currentFragment) != null) {
                    ++currentIndex;
                }
                inToken = false;
                inNothing = true;
            }
            char c = input.charAt(i);
            if (inNothing && c == '\'' && !TextLiteralExpression.isDelimiterEscaped(input, i)) {
                ExpressionParsingUtil.finishCurrentFragment(decomposedInput, currentFragment);
                currentFragment.append(c);
                inLiteral = true;
                inNothing = false;
                continue;
            }
            if (inLiteral && c == '\'' && !TextLiteralExpression.isDelimiterEscaped(input, i)) {
                currentFragment.append(c);
                TextLiteralExpression expr = TextLiteralExpression.parseTextLiteralExpression(currentFragment.toString());
                if (ExpressionParsingUtil.addExpressionAtIndex(expr, currentIndex++, state, decomposedInput, currentFragment) == null) {
                    return null;
                }
                inLiteral = false;
                inNothing = true;
                continue;
            }
            if (inLiteral) {
                currentFragment.append(c);
                continue;
            }
            if (inNothing && (c == '$' || c == '*' || c == '#' || c == '@' || c == '~') && i + 1 < inputLen && input.charAt(i + 1) == '{') {
                ExpressionParsingUtil.finishCurrentFragment(decomposedInput, currentFragment);
                currentFragment.append(c);
                currentFragment.append('{');
                ++i;
                expLevel = 1;
                inNothing = false;
                continue;
            }
            if (expLevel == 1 && c == '}') {
                SimpleExpression expr;
                currentFragment.append('}');
                char expSelectorChar = currentFragment.charAt(0);
                switch (expSelectorChar) {
                    case '$': {
                        expr = VariableExpression.parseVariableExpression(currentFragment.toString());
                        break;
                    }
                    case '*': {
                        expr = SelectionVariableExpression.parseSelectionVariableExpression(currentFragment.toString());
                        break;
                    }
                    case '#': {
                        expr = MessageExpression.parseMessageExpression(currentFragment.toString());
                        break;
                    }
                    case '@': {
                        expr = LinkExpression.parseLinkExpression(currentFragment.toString());
                        break;
                    }
                    case '~': {
                        expr = FragmentExpression.parseFragmentExpression(currentFragment.toString());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (ExpressionParsingUtil.addExpressionAtIndex(expr, currentIndex++, state, decomposedInput, currentFragment) == null) {
                    return null;
                }
                expLevel = 0;
                inNothing = true;
                continue;
            }
            if (expLevel > 0 && c == '{') {
                ++expLevel;
                currentFragment.append('{');
                continue;
            }
            if (expLevel > 1 && c == '}') {
                --expLevel;
                currentFragment.append('}');
                continue;
            }
            if (expLevel > 0) {
                currentFragment.append(c);
                continue;
            }
            if (inNothing && Token.isTokenChar(input, i)) {
                ExpressionParsingUtil.finishCurrentFragment(decomposedInput, currentFragment);
                currentFragment.append(c);
                inToken = true;
                inNothing = false;
                continue;
            }
            currentFragment.append(c);
        }
        if (inLiteral || expLevel > 0) {
            return null;
        }
        if (inToken && ExpressionParsingUtil.finishCurrentToken(currentIndex++, state, decomposedInput, currentFragment) != null) {
            ++currentIndex;
        }
        decomposedInput.append((CharSequence)currentFragment);
        state.insertNode(0, decomposedInput.toString());
        return state;
    }

    private static Expression addExpressionAtIndex(Expression expression, int index, ExpressionParsingState state, StringBuilder decomposedInput, StringBuilder currentFragment) {
        if (expression == null) {
            return null;
        }
        decomposedInput.append('\u00a7');
        decomposedInput.append(String.valueOf(index));
        decomposedInput.append('\u00a7');
        state.addNode(expression);
        currentFragment.setLength(0);
        return expression;
    }

    private static void finishCurrentFragment(StringBuilder decomposedInput, StringBuilder currentFragment) {
        decomposedInput.append((CharSequence)currentFragment);
        currentFragment.setLength(0);
    }

    private static Expression finishCurrentToken(int currentIndex, ExpressionParsingState state, StringBuilder decomposedInput, StringBuilder currentFragment) {
        String token = currentFragment.toString();
        Expression expr = ExpressionParsingUtil.parseAsToken(token);
        if (ExpressionParsingUtil.addExpressionAtIndex(expr, currentIndex, state, decomposedInput, currentFragment) == null) {
            decomposedInput.append((CharSequence)currentFragment);
            currentFragment.setLength(0);
            return null;
        }
        return expr;
    }

    private static Expression parseAsToken(String token) {
        if (ArrayUtils.contains(PROTECTED_TOKENS, token.toLowerCase())) {
            return null;
        }
        NumberTokenExpression numberTokenExpr = NumberTokenExpression.parseNumberTokenExpression(token);
        if (numberTokenExpr != null) {
            return numberTokenExpr;
        }
        BooleanTokenExpression booleanTokenExpr = BooleanTokenExpression.parseBooleanTokenExpression(token);
        if (booleanTokenExpr != null) {
            return booleanTokenExpr;
        }
        NullTokenExpression nullTokenExpr = NullTokenExpression.parseNullTokenExpression(token);
        if (nullTokenExpr != null) {
            return nullTokenExpr;
        }
        NoOpTokenExpression noOpTokenExpr = NoOpTokenExpression.parseNoOpTokenExpression(token);
        if (noOpTokenExpr != null) {
            return noOpTokenExpr;
        }
        GenericTokenExpression genericTokenExpr = GenericTokenExpression.parseGenericTokenExpression(token);
        if (genericTokenExpr != null) {
            return genericTokenExpr;
        }
        return null;
    }

    public static ExpressionParsingState unnest(ExpressionParsingState state) {
        Validate.notNull(state, "Parsing state cannot be null");
        return ExpressionParsingUtil.decomposeNestingParenthesis(state, 0);
    }

    private static ExpressionParsingState decomposeNestingParenthesis(ExpressionParsingState state, int nodeIndex) {
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        StringBuilder decomposedString = new StringBuilder(24);
        StringBuilder currentFragment = new StringBuilder(24);
        int currentIndex = state.size();
        ArrayList<Integer> nestedInputs = new ArrayList<Integer>(6);
        int parLevel = 0;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                if (parLevel == 0) {
                    decomposedString.append((CharSequence)currentFragment);
                    currentFragment.setLength(0);
                } else {
                    currentFragment.append('(');
                }
                ++parLevel;
                continue;
            }
            if (c == ')') {
                if (--parLevel < 0) {
                    return null;
                }
                if (parLevel == 0) {
                    int nestedIndex = currentIndex++;
                    nestedInputs.add(nestedIndex);
                    decomposedString.append('\u00a7');
                    decomposedString.append(String.valueOf(nestedIndex));
                    decomposedString.append('\u00a7');
                    state.addNode(currentFragment.toString());
                    currentFragment.setLength(0);
                    continue;
                }
                currentFragment.append(')');
                continue;
            }
            currentFragment.append(c);
        }
        if (parLevel > 0) {
            return null;
        }
        decomposedString.append((CharSequence)currentFragment);
        state.setNode(nodeIndex, decomposedString.toString());
        for (Integer nestedInput : nestedInputs) {
            if (ExpressionParsingUtil.decomposeNestingParenthesis(state, nestedInput) != null) continue;
            return null;
        }
        return state;
    }

    public static ExpressionParsingState compose(ExpressionParsingState state) {
        return ExpressionParsingUtil.compose(state, 0);
    }

    static ExpressionParsingState compose(ExpressionParsingState state, int nodeIndex) {
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int parsedIndex = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(input);
        if (parsedIndex != -1) {
            if (ExpressionParsingUtil.compose(state, parsedIndex) == null) {
                return null;
            }
            if (!state.hasExpressionAt(parsedIndex)) {
                return null;
            }
            state.setNode(nodeIndex, ((ExpressionParsingNode)state.get(parsedIndex)).getExpression());
            return state;
        }
        if (ConditionalExpression.composeConditionalExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (DefaultExpression.composeDefaultExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (OrExpression.composeOrExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (AndExpression.composeAndExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (EqualsNotEqualsExpression.composeEqualsNotEqualsExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (GreaterLesserExpression.composeGreaterLesserExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (AdditionSubtractionExpression.composeAdditionSubtractionExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (MultiplicationDivisionRemainderExpression.composeMultiplicationDivisionRemainderExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (MinusExpression.composeMinusExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        if (NegationExpression.composeNegationExpression(state, nodeIndex) == null) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            return state;
        }
        return null;
    }

    public static int parseAsSimpleIndexPlaceholder(String placeholder) {
        String str = placeholder.trim();
        int strLen = str.length();
        if (strLen <= 2) {
            return -1;
        }
        if (str.charAt(0) != '\u00a7' || str.charAt(strLen - 1) != '\u00a7') {
            return -1;
        }
        for (int i = 1; i < strLen - 1; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return -1;
        }
        return Integer.parseInt(str.substring(1, strLen - 1));
    }

    static Expression parseAndCompose(ExpressionParsingState state, String parseTarget) {
        int index = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(parseTarget);
        if (index == -1) {
            index = state.size();
            state.addNode(parseTarget);
        }
        if (ExpressionParsingUtil.compose(state, index) == null || !state.hasExpressionAt(index)) {
            return null;
        }
        return ((ExpressionParsingNode)state.get(index)).getExpression();
    }

    private ExpressionParsingUtil() {
    }

    static {
        ArrayList<String> protectedTokenList = new ArrayList<String>(30);
        protectedTokenList.addAll(Arrays.asList(AndExpression.OPERATORS));
        protectedTokenList.addAll(Arrays.asList(EqualsNotEqualsExpression.OPERATORS));
        protectedTokenList.addAll(Arrays.asList(GreaterLesserExpression.OPERATORS));
        protectedTokenList.addAll(Arrays.asList(MultiplicationDivisionRemainderExpression.OPERATORS));
        protectedTokenList.addAll(Arrays.asList(NegationExpression.OPERATORS));
        protectedTokenList.addAll(Arrays.asList(OrExpression.OPERATORS));
        PROTECTED_TOKENS = protectedTokenList.toArray(new String[protectedTokenList.size()]);
    }
}

