/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Token;

public final class NullTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NullTokenExpression.class);
    private static final long serialVersionUID = -927282151625647619L;
    private static final NullTokenExpression SINGLETON = new NullTokenExpression();

    public NullTokenExpression() {
        super(null);
    }

    @Override
    public String getStringRepresentation() {
        return "null";
    }

    static NullTokenExpression parseNullTokenExpression(String input) {
        if ("null".equalsIgnoreCase(input)) {
            return SINGLETON;
        }
        return null;
    }

    static Object executeNullTokenExpression(IExpressionContext context, NullTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating null token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

