/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LiteralValue;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MultiplicationDivisionRemainderExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;

public final class RemainderExpression
extends MultiplicationDivisionRemainderExpression {
    private static final long serialVersionUID = -8830009392616779821L;
    private static final Logger logger = LoggerFactory.getLogger(RemainderExpression.class);

    public RemainderExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation("%");
    }

    static Object executeRemainder(IExpressionContext context, RemainderExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating remainder expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = expression.getLeft().execute(context, expContext);
        Object rightValue = expression.getRight().execute(context, expContext);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        BigDecimal leftNumberValue = EvaluationUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            return leftNumberValue.remainder(rightNumberValue);
        }
        throw new TemplateProcessingException("Cannot execute division: operands are \"" + LiteralValue.unwrap(leftValue) + "\" and \"" + LiteralValue.unwrap(rightValue) + "\"");
    }
}

