/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.BooleanTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.GenericTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LinkExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MessageExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NullTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NumberTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.SelectionVariableExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.TextLiteralExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.VariableExpression;

public abstract class SimpleExpression
extends Expression {
    private static final long serialVersionUID = 9145380484247069725L;
    static final char EXPRESSION_START_CHAR = '{';
    static final char EXPRESSION_END_CHAR = '}';

    protected SimpleExpression() {
    }

    static Object executeSimple(IExpressionContext context, SimpleExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator, StandardExpressionExecutionContext expContext) {
        if (expression instanceof VariableExpression) {
            return VariableExpression.executeVariableExpression(context, (VariableExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof MessageExpression) {
            return MessageExpression.executeMessageExpression(context, (MessageExpression)expression, expContext);
        }
        if (expression instanceof TextLiteralExpression) {
            return TextLiteralExpression.executeTextLiteralExpression(context, (TextLiteralExpression)expression, expContext);
        }
        if (expression instanceof NumberTokenExpression) {
            return NumberTokenExpression.executeNumberTokenExpression(context, (NumberTokenExpression)expression, expContext);
        }
        if (expression instanceof BooleanTokenExpression) {
            return BooleanTokenExpression.executeBooleanTokenExpression(context, (BooleanTokenExpression)expression, expContext);
        }
        if (expression instanceof NullTokenExpression) {
            return NullTokenExpression.executeNullTokenExpression(context, (NullTokenExpression)expression, expContext);
        }
        if (expression instanceof LinkExpression) {
            return LinkExpression.executeLinkExpression(context, (LinkExpression)expression);
        }
        if (expression instanceof FragmentExpression) {
            return FragmentExpression.executeFragmentExpression(context, (FragmentExpression)expression);
        }
        if (expression instanceof SelectionVariableExpression) {
            return SelectionVariableExpression.executeSelectionVariableExpression(context, (SelectionVariableExpression)expression, expressionEvaluator, expContext);
        }
        if (expression instanceof NoOpTokenExpression) {
            return NoOpTokenExpression.executeNoOpTokenExpression(context, (NoOpTokenExpression)expression, expContext);
        }
        if (expression instanceof GenericTokenExpression) {
            return GenericTokenExpression.executeGenericTokenExpression(context, (GenericTokenExpression)expression, expContext);
        }
        throw new TemplateProcessingException("Unrecognized simple expression: " + expression.getClass().getName());
    }
}

