/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AssignationSequence;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.AssignationUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Each;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.EachUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionCache;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionSequence;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentSignature;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class StandardExpressionParser
implements IStandardExpressionParser {
    @Override
    public Expression parseExpression(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return (Expression)StandardExpressionParser.parseExpression(context, input, true);
    }

    public AssignationSequence parseAssignationSequence(IExpressionContext context, String input, boolean allowParametersWithoutValue) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return AssignationUtils.parseAssignationSequence(context, input, allowParametersWithoutValue);
    }

    public ExpressionSequence parseExpressionSequence(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return ExpressionSequenceUtils.parseExpressionSequence(context, input);
    }

    public Each parseEach(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return EachUtils.parseEach(context, input);
    }

    public FragmentSignature parseFragmentSignature(IEngineConfiguration configuration, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return FragmentSignatureUtils.parseFragmentSignature(configuration, input);
    }

    static IStandardExpression parseExpression(IExpressionContext context, String input, boolean preprocess) {
        String preprocessedInput;
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpression cachedExpression = ExpressionCache.getExpressionFromCache(configuration, preprocessedInput = preprocess ? StandardExpressionPreprocessor.preprocess(context, input) : input);
        if (cachedExpression != null) {
            return cachedExpression;
        }
        Expression expression = Expression.parse(preprocessedInput.trim());
        if (expression == null) {
            throw new TemplateProcessingException("Could not parse as expression: \"" + input + "\"");
        }
        ExpressionCache.putExpressionIntoCache(configuration, preprocessedInput, expression);
        return expression;
    }

    public String toString() {
        return "Standard Expression Parser";
    }
}

