/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;

final class StandardExpressionPreprocessor {
    private static final char PREPROCESS_DELIMITER = '_';
    private static final String PREPROCESS_EVAL = "\\_\\_(.*?)\\_\\_";
    private static final Pattern PREPROCESS_EVAL_PATTERN = Pattern.compile("\\_\\_(.*?)\\_\\_", 32);

    static String preprocess(IExpressionContext context, String input) {
        if (input.indexOf(95) == -1) {
            return input;
        }
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        if (!(expressionParser instanceof StandardExpressionParser)) {
            return input;
        }
        Matcher matcher = PREPROCESS_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder(input.length() + 24);
            int curr = 0;
            do {
                String previousText = StandardExpressionPreprocessor.checkPreprocessingMarkUnescaping(input.substring(curr, matcher.start(0)));
                String expressionText = StandardExpressionPreprocessor.checkPreprocessingMarkUnescaping(matcher.group(1));
                strBuilder.append(previousText);
                IStandardExpression expression = StandardExpressionParser.parseExpression(context, expressionText, false);
                if (expression == null) {
                    return null;
                }
                Object result = expression.execute(context, StandardExpressionExecutionContext.RESTRICTED);
                strBuilder.append(result);
                curr = matcher.end(0);
            } while (matcher.find());
            String remaining = StandardExpressionPreprocessor.checkPreprocessingMarkUnescaping(input.substring(curr));
            strBuilder.append(remaining);
            return strBuilder.toString().trim();
        }
        return StandardExpressionPreprocessor.checkPreprocessingMarkUnescaping(input);
    }

    private static String checkPreprocessingMarkUnescaping(String input) {
        boolean structureFound = false;
        int state = 0;
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == '\\' && (state == 0 || state == 2)) {
                state = (byte)(state + 1);
                continue;
            }
            if (c == '_' && state == 1) {
                state = (byte)(state + 1);
                continue;
            }
            if (c == '_' && state == 3) {
                structureFound = true;
                break;
            }
            state = 0;
        }
        if (!structureFound) {
            return input;
        }
        state = 0;
        StringBuilder strBuilder = new StringBuilder(inputLen + 6);
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == '\\' && (state == 0 || state == 2)) {
                state = (byte)(state + 1);
                strBuilder.append('\\');
                continue;
            }
            if (c == '_' && state == 1) {
                state = (byte)(state + 1);
                strBuilder.append('_');
                continue;
            }
            if (c == '_' && state == 3) {
                state = 0;
                int builderLen = strBuilder.length();
                strBuilder.delete(builderLen - 3, builderLen);
                strBuilder.append("__");
                continue;
            }
            state = 0;
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    private StandardExpressionPreprocessor() {
    }
}

