/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.LiteralValue;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.SimpleExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class TextLiteralExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(TextLiteralExpression.class);
    private static final long serialVersionUID = 6511847028638506552L;
    static final char ESCAPE_PREFIX = '\\';
    static final char DELIMITER = '\'';
    private final LiteralValue value;

    public TextLiteralExpression(String value) {
        Validate.notNull(value, "Value cannot be null");
        this.value = new LiteralValue(TextLiteralExpression.unwrapLiteral(value));
    }

    public LiteralValue getValue() {
        return this.value;
    }

    private static String unwrapLiteral(String input) {
        int inputLen = input.length();
        if (inputLen > 1 && input.charAt(0) == '\'' && input.charAt(inputLen - 1) == '\'') {
            return TextLiteralExpression.unescapeLiteral(input.substring(1, inputLen - 1));
        }
        return input;
    }

    @Override
    public String getStringRepresentation() {
        return String.valueOf('\'') + this.value.getValue().replace(String.valueOf('\''), "\\'") + String.valueOf('\'');
    }

    static TextLiteralExpression parseTextLiteralExpression(String input) {
        return new TextLiteralExpression(input);
    }

    static Object executeTextLiteralExpression(IExpressionContext context, TextLiteralExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating text literal: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }

    public static String wrapStringIntoLiteral(String str) {
        if (str == null) {
            return null;
        }
        int n = str.length();
        while (n-- != 0) {
            if (str.charAt(n) != '\'') continue;
            StringBuilder strBuilder = new StringBuilder(str.length() + 5);
            strBuilder.append('\'');
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                char c = str.charAt(i);
                if (c == '\'') {
                    strBuilder.append('\\');
                }
                strBuilder.append(c);
            }
            strBuilder.append('\'');
            return strBuilder.toString();
        }
        return '\'' + str + '\'';
    }

    static boolean isDelimiterEscaped(String input, int pos) {
        if (pos == 0 || input.charAt(pos - 1) != '\\') {
            return false;
        }
        boolean odd = false;
        for (int i = pos - 1; i >= 0; --i) {
            if (input.charAt(i) != '\\') {
                return odd;
            }
            odd = !odd;
        }
        return odd;
    }

    private static String unescapeLiteral(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder strBuilder = null;
        int max = text.length();
        int readOffset = 0;
        int referenceOffset = 0;
        for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            if (c != '\\' || i + 1 >= max) continue;
            if (c == '\\') {
                switch (text.charAt(i + 1)) {
                    case '\'': {
                        c = '\'';
                        referenceOffset = i + 1;
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        referenceOffset = i + 1;
                        break;
                    }
                    default: {
                        referenceOffset = i;
                    }
                }
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 5);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            i = referenceOffset;
            readOffset = i + 1;
            strBuilder.append(c);
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        return strBuilder.toString();
    }
}

