/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import java.util.List;
import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateAssertionException;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionSequence;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;

public abstract class AbstractStandardAssertionTagProcessor
extends AbstractAttributeTagProcessor {
    protected AbstractStandardAssertionTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        if (StringUtils.isEmptyOrWhitespace(attributeValue)) {
            return;
        }
        ExpressionSequence expressionSequence = ExpressionSequenceUtils.parseExpressionSequence(context, attributeValue);
        List<IStandardExpression> expressions = expressionSequence.getExpressions();
        for (IStandardExpression expression : expressions) {
            Object expressionResult = expression.execute(context);
            boolean expressionBooleanResult = EvaluationUtils.evaluateAsBoolean(expressionResult);
            if (expressionBooleanResult) continue;
            throw new TemplateAssertionException(expression.getStringRepresentation(), tag.getTemplateName(), tag.getAttribute(attributeName).getLine(), tag.getAttribute(attributeName).getCol());
        }
    }
}

