/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.standard.util.StandardProcessorUtils;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EscapedAttributeUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public abstract class AbstractStandardDoubleAttributeModifierTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    private final boolean removeIfEmpty;
    private final String attributeOneCompleteName;
    private final String attributeTwoCompleteName;
    private AttributeDefinition attributeOneDefinition;
    private AttributeDefinition attributeTwoDefinition;

    protected AbstractStandardDoubleAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, String attributeOneCompleteName, String attributeTwoCompleteName, boolean removeIfEmpty) {
        super(templateMode, dialectPrefix, attrName, precedence, true, false);
        Validate.notNull(attributeOneCompleteName, "Complete name of attribute one cannot be null");
        Validate.notNull(attributeTwoCompleteName, "Complete name of attribute one cannot be null");
        this.removeIfEmpty = removeIfEmpty;
        this.attributeOneCompleteName = attributeOneCompleteName;
        this.attributeTwoCompleteName = attributeTwoCompleteName;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.attributeOneDefinition = attributeDefinitions.forName(this.getTemplateMode(), this.attributeOneCompleteName);
        this.attributeTwoDefinition = attributeDefinitions.forName(this.getTemplateMode(), this.attributeTwoCompleteName);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = EscapedAttributeUtils.escapeAttribute(this.getTemplateMode(), expressionResult == null ? null : expressionResult.toString());
        if (this.removeIfEmpty && (newAttributeValue == null || newAttributeValue.length() == 0)) {
            structureHandler.removeAttribute(this.attributeOneDefinition.getAttributeName());
            structureHandler.removeAttribute(this.attributeTwoDefinition.getAttributeName());
        } else {
            StandardProcessorUtils.setAttribute(structureHandler, this.attributeOneDefinition, this.attributeOneCompleteName, newAttributeValue);
            StandardProcessorUtils.setAttribute(structureHandler, this.attributeTwoDefinition, this.attributeTwoCompleteName, newAttributeValue);
        }
    }
}

