/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import org.ezlibs.shaded.org.attoparser.util.TextUtil;
import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.IAttribute;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.processor.element.MatchingAttributeName;
import org.ezlibs.shaded.org.thymeleaf.processor.element.MatchingElementName;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpToken;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EscapedAttributeUtils;

public final class StandardDefaultAttributesTagProcessor
extends AbstractProcessor
implements IElementTagProcessor {
    public static final int PRECEDENCE = Integer.MAX_VALUE;
    private final String dialectPrefix;
    private final MatchingAttributeName matchingAttributeName;

    public StandardDefaultAttributesTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, Integer.MAX_VALUE);
        this.dialectPrefix = dialectPrefix;
        this.matchingAttributeName = MatchingAttributeName.forAllAttributesWithPrefix(this.getTemplateMode(), dialectPrefix);
    }

    @Override
    public final MatchingElementName getMatchingElementName() {
        return null;
    }

    @Override
    public final MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    @Override
    public void process(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        IAttribute[] attributes;
        TemplateMode templateMode = this.getTemplateMode();
        for (IAttribute attribute : attributes = tag.getAllAttributes()) {
            AttributeName attributeName = attribute.getAttributeDefinition().getAttributeName();
            if (!attributeName.isPrefixed() || !TextUtil.equals(templateMode.isCaseSensitive(), (CharSequence)attributeName.getPrefix(), this.dialectPrefix)) continue;
            StandardDefaultAttributesTagProcessor.processDefaultAttribute(this.getTemplateMode(), context, tag, attribute, structureHandler);
        }
    }

    private static void processDefaultAttribute(TemplateMode templateMode, ITemplateContext context, IProcessableElementTag tag, IAttribute attribute, IElementTagStructureHandler structureHandler) {
        try {
            Object expressionResult;
            AttributeName attributeName = attribute.getAttributeDefinition().getAttributeName();
            String attributeValue = EscapedAttributeUtils.unescapeAttribute(context.getTemplateMode(), attribute.getValue());
            String originalCompleteAttributeName = attribute.getAttributeCompleteName();
            String canonicalAttributeName = attributeName.getAttributeName();
            String newAttributeName = TextUtil.endsWith(true, (CharSequence)originalCompleteAttributeName, canonicalAttributeName) ? canonicalAttributeName : originalCompleteAttributeName.substring(originalCompleteAttributeName.length() - canonicalAttributeName.length());
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
            if (attributeValue != null) {
                IStandardExpression expression = expressionParser.parseExpression(context, attributeValue);
                if (expression != null && expression instanceof FragmentExpression) {
                    FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression(context, (FragmentExpression)expression);
                    expressionResult = FragmentExpression.resolveExecutedFragmentExpression(context, executedFragmentExpression, true);
                } else {
                    expressionResult = expression.execute(context, StandardExpressionExecutionContext.RESTRICTED);
                }
            } else {
                expressionResult = null;
            }
            if (expressionResult == NoOpToken.VALUE) {
                structureHandler.removeAttribute(attributeName);
                return;
            }
            String newAttributeValue = EscapedAttributeUtils.escapeAttribute(templateMode, expressionResult == null ? null : expressionResult.toString());
            if (newAttributeValue == null || newAttributeValue.length() == 0) {
                structureHandler.removeAttribute(newAttributeName);
                structureHandler.removeAttribute(attributeName);
            } else {
                structureHandler.replaceAttribute(attributeName, newAttributeName, newAttributeValue == null ? "" : newAttributeValue);
            }
        }
        catch (TemplateProcessingException e) {
            if (!e.hasTemplateName()) {
                e.setTemplateName(tag.getTemplateName());
            }
            if (!e.hasLineAndCol()) {
                e.setLineAndCol(attribute.getLine(), attribute.getCol());
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + StandardDefaultAttributesTagProcessor.class.getName() + "'", tag.getTemplateName(), attribute.getLine(), attribute.getCol(), e);
        }
    }
}

