/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.EngineEventUtils;
import org.ezlibs.shaded.org.thymeleaf.inline.IInliner;
import org.ezlibs.shaded.org.thymeleaf.inline.NoOpInliner;
import org.ezlibs.shaded.org.thymeleaf.model.IText;
import org.ezlibs.shaded.org.thymeleaf.processor.text.AbstractTextProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.text.ITextStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public final class StandardInliningTextProcessor
extends AbstractTextProcessor {
    public static final int PRECEDENCE = 1000;

    public StandardInliningTextProcessor(TemplateMode templateMode) {
        super(templateMode, 1000);
    }

    @Override
    protected void doProcess(ITemplateContext context, IText text, ITextStructureHandler structureHandler) {
        if (EngineEventUtils.isWhitespace(text)) {
            return;
        }
        IInliner inliner = context.getInliner();
        if (inliner == null || inliner == NoOpInliner.INSTANCE) {
            return;
        }
        CharSequence inlined = inliner.inline(context, text);
        if (inlined != null && inlined != text) {
            structureHandler.setText(inlined);
        }
    }
}

