/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import java.util.Set;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateModel;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.postprocessor.IPostProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Fragment;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpToken;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public final class StandardUtextTagProcessor
extends AbstractAttributeTagProcessor {
    public static final int PRECEDENCE = 1400;
    public static final String ATTR_NAME = "utext";

    public StandardUtextTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, null, false, ATTR_NAME, true, 1400, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        Object expressionResult;
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(configuration);
        IStandardExpression expression = expressionParser.parseExpression(context, attributeValue);
        if (expression != null && expression instanceof FragmentExpression) {
            FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression(context, (FragmentExpression)expression);
            expressionResult = FragmentExpression.resolveExecutedFragmentExpression(context, executedFragmentExpression, true);
        } else {
            expressionResult = expression.execute(context, StandardExpressionExecutionContext.RESTRICTED);
        }
        if (expressionResult == NoOpToken.VALUE) {
            return;
        }
        if (expressionResult != null && expressionResult instanceof Fragment) {
            if (expressionResult == Fragment.EMPTY_FRAGMENT) {
                structureHandler.removeBody();
                return;
            }
            structureHandler.setBody(((Fragment)expressionResult).getTemplateModel(), false);
            return;
        }
        String unescapedTextStr = expressionResult == null ? "" : expressionResult.toString();
        Set<IPostProcessor> postProcessors = configuration.getPostProcessors(this.getTemplateMode());
        if (postProcessors.isEmpty()) {
            structureHandler.setBody(unescapedTextStr, false);
            return;
        }
        if (!StandardUtextTagProcessor.mightContainStructures(unescapedTextStr)) {
            structureHandler.setBody(unescapedTextStr, false);
            return;
        }
        TemplateModel parsedFragment = configuration.getTemplateManager().parseString(context.getTemplateData(), unescapedTextStr, 0, 0, null, false);
        structureHandler.setBody(parsedFragment, false);
    }

    private static boolean mightContainStructures(CharSequence unescapedText) {
        int n = unescapedText.length();
        while (n-- != 0) {
            char c = unescapedText.charAt(n);
            if (c != '>' && c != ']') continue;
            return true;
        }
        return false;
    }
}

