/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.util;

public final class StandardConditionalCommentUtils {
    public static ConditionalCommentParsingResult parseConditionalComment(CharSequence text) {
        int i;
        int len = text.length();
        for (i = 4; i < len && Character.isWhitespace(text.charAt(i)); ++i) {
        }
        if (i >= len || text.charAt(i++) != '[') {
            return null;
        }
        int startExpressionOffset = i;
        while (i < len && text.charAt(i) != ']') {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        int startExpressionLen = i - startExpressionOffset;
        ++i;
        while (i < len && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        if (i >= len || text.charAt(i++) != '>') {
            return null;
        }
        int contentOffset = i;
        for (i = len - 3 - 1; i > contentOffset && Character.isWhitespace(text.charAt(i)); --i) {
        }
        if (i <= contentOffset || text.charAt(i--) != ']') {
            return null;
        }
        int endExpressionLastPos = i + 1;
        while (i > contentOffset && text.charAt(i) != '[') {
            --i;
        }
        if (i <= contentOffset) {
            return null;
        }
        int endExpressionOffset = i + 1;
        int endExpressionLen = endExpressionLastPos - endExpressionOffset;
        --i;
        while (i >= contentOffset && Character.isWhitespace(text.charAt(i))) {
            --i;
        }
        if (i <= contentOffset || text.charAt(i--) != '!') {
            return null;
        }
        if (i <= contentOffset || text.charAt(i--) != '<') {
            return null;
        }
        int contentLen = i + 1 - contentOffset;
        if (contentLen <= 0 || startExpressionLen <= 0 || endExpressionLen <= 0) {
            return null;
        }
        return new ConditionalCommentParsingResult(startExpressionOffset, startExpressionLen, contentOffset, contentLen, endExpressionOffset, endExpressionLen);
    }

    private StandardConditionalCommentUtils() {
    }

    public static final class ConditionalCommentParsingResult {
        private final int startExpressionOffset;
        private final int startExpressionLen;
        private final int contentOffset;
        private final int contentLen;
        private final int endExpressionOffset;
        private final int endExpressionLen;

        public ConditionalCommentParsingResult(int startExpressionOffset, int startExpressionLen, int contentOffset, int contentLen, int endExpressionOffset, int endExpressionLen) {
            this.startExpressionOffset = startExpressionOffset;
            this.startExpressionLen = startExpressionLen;
            this.contentOffset = contentOffset;
            this.contentLen = contentLen;
            this.endExpressionOffset = endExpressionOffset;
            this.endExpressionLen = endExpressionLen;
        }

        public int getStartExpressionOffset() {
            return this.startExpressionOffset;
        }

        public int getStartExpressionLen() {
            return this.startExpressionLen;
        }

        public int getContentOffset() {
            return this.contentOffset;
        }

        public int getContentLen() {
            return this.contentLen;
        }

        public int getEndExpressionOffset() {
            return this.endExpressionOffset;
        }

        public int getEndExpressionLen() {
            return this.endExpressionLen;
        }
    }
}

