/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templateresolver;

import java.util.Map;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.ezlibs.shaded.org.thymeleaf.cache.ICacheEntryValidity;
import org.ezlibs.shaded.org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.ezlibs.shaded.org.thymeleaf.cache.TTLCacheEntryValidity;
import org.ezlibs.shaded.org.thymeleaf.exceptions.ConfigurationException;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.templateresource.StringTemplateResource;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public class StringTemplateResolver
extends AbstractTemplateResolver {
    public static final TemplateMode DEFAULT_TEMPLATE_MODE = TemplateMode.HTML;
    public static final boolean DEFAULT_CACHEABLE = false;
    public static final Long DEFAULT_CACHE_TTL_MS = null;
    private TemplateMode templateMode = DEFAULT_TEMPLATE_MODE;
    private boolean cacheable = false;
    private Long cacheTTLMs = DEFAULT_CACHE_TTL_MS;

    public final TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public final void setTemplateMode(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = TemplateMode.parse(templateMode.toString());
    }

    public final void setTemplateMode(String templateMode) {
        Validate.notNull(templateMode, "Cannot set a null template mode value");
        this.templateMode = TemplateMode.parse(templateMode);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public final void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public final Long getCacheTTLMs() {
        return this.cacheTTLMs;
    }

    public final void setCacheTTLMs(Long cacheTTLMs) {
        this.cacheTTLMs = cacheTTLMs;
    }

    @Override
    public void setUseDecoupledLogic(boolean useDecoupledLogic) {
        if (useDecoupledLogic) {
            throw new ConfigurationException("The 'useDecoupledLogic' flag is not allowed for String template resolution");
        }
        super.setUseDecoupledLogic(useDecoupledLogic);
    }

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return new StringTemplateResource(template);
    }

    @Override
    protected TemplateMode computeTemplateMode(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return this.templateMode;
    }

    @Override
    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (this.isCacheable()) {
            if (this.cacheTTLMs != null) {
                return new TTLCacheEntryValidity(this.cacheTTLMs);
            }
            return AlwaysValidCacheEntryValidity.INSTANCE;
        }
        return NonCacheableCacheEntryValidity.INSTANCE;
    }
}

