/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import javax.servlet.ServletContext;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.templateresource.TemplateResourceUtils;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class ServletContextTemplateResource
implements ITemplateResource {
    private final ServletContext servletContext;
    private final String path;
    private final String characterEncoding;

    public ServletContextTemplateResource(ServletContext servletContext, String path, String characterEncoding) {
        Validate.notNull(servletContext, "ServletContext cannot be null");
        Validate.notEmpty(path, "Resource Path cannot be null or empty");
        this.servletContext = servletContext;
        String cleanPath = TemplateResourceUtils.cleanPath(path);
        this.path = cleanPath.charAt(0) != '/' ? "/" + cleanPath : cleanPath;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public String getBaseName() {
        return TemplateResourceUtils.computeBaseName(this.path);
    }

    @Override
    public Reader reader() throws IOException {
        InputStream inputStream = this.servletContext.getResourceAsStream(this.path);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("ServletContext resource \"%s\" does not exist", this.path));
        }
        if (!StringUtils.isEmptyOrWhitespace(this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        Validate.notEmpty(relativeLocation, "Relative Path cannot be null or empty");
        String fullRelativeLocation = TemplateResourceUtils.computeRelativeLocation(this.path, relativeLocation);
        return new ServletContextTemplateResource(this.servletContext, fullRelativeLocation, this.characterEncoding);
    }

    @Override
    public boolean exists() {
        try {
            return this.servletContext.getResource(this.path) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

