/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.util;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;

public final class ContentTypeUtils {
    private static final String[] MIME_TYPES_HTML = new String[]{"text/html", "application/xhtml+xml"};
    private static final String[] MIME_TYPES_XML = new String[]{"application/xml", "text/xml"};
    private static final String[] MIME_TYPES_RSS = new String[]{"application/rss+xml"};
    private static final String[] MIME_TYPES_ATOM = new String[]{"application/atom+xml"};
    private static final String[] MIME_TYPES_JAVASCRIPT = new String[]{"application/javascript", "application/x-javascript", "application/ecmascript", "text/javascript", "text/ecmascript"};
    private static final String[] MIME_TYPES_JSON = new String[]{"application/json"};
    private static final String[] MIME_TYPES_CSS = new String[]{"text/css"};
    private static final String[] MIME_TYPES_TEXT = new String[]{"text/plain"};
    private static final String[] MIME_TYPES_SSE = new String[]{"text/event-stream"};
    private static final String[] FILE_EXTENSIONS_HTML = new String[]{".html", ".htm", ".xhtml"};
    private static final String[] FILE_EXTENSIONS_XML = new String[]{".xml"};
    private static final String[] FILE_EXTENSIONS_RSS = new String[]{".rss"};
    private static final String[] FILE_EXTENSIONS_ATOM = new String[]{".atom"};
    private static final String[] FILE_EXTENSIONS_JAVASCRIPT = new String[]{".js"};
    private static final String[] FILE_EXTENSIONS_JSON = new String[]{".json"};
    private static final String[] FILE_EXTENSIONS_CSS = new String[]{".css"};
    private static final String[] FILE_EXTENSIONS_TEXT = new String[]{".txt"};
    private static final Map<String, String> NORMALIZED_MIME_TYPES;
    private static final Map<String, String> MIME_TYPE_BY_FILE_EXTENSION;
    private static final Map<String, TemplateMode> TEMPLATE_MODE_BY_MIME_TYPE;

    public static boolean isContentTypeHTML(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_HTML[0]);
    }

    public static boolean isContentTypeXML(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_XML[0]);
    }

    public static boolean isContentTypeRSS(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_RSS[0]);
    }

    public static boolean isContentTypeAtom(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_ATOM[0]);
    }

    public static boolean isContentTypeJavaScript(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_JAVASCRIPT[0]);
    }

    public static boolean isContentTypeJSON(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_JSON[0]);
    }

    public static boolean isContentTypeCSS(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_CSS[0]);
    }

    public static boolean isContentTypeText(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_TEXT[0]);
    }

    public static boolean isContentTypeSSE(String contentType) {
        return ContentTypeUtils.isContentType(contentType, MIME_TYPES_SSE[0]);
    }

    private static boolean isContentType(String contentType, String matcher) {
        if (contentType == null || contentType.trim().length() == 0) {
            return false;
        }
        ContentType contentTypeObj = ContentType.parseContentType(contentType);
        if (contentTypeObj == null) {
            return false;
        }
        String normalisedMimeType = NORMALIZED_MIME_TYPES.get(contentTypeObj.getMimeType());
        if (normalisedMimeType == null) {
            return false;
        }
        return normalisedMimeType.equals(matcher);
    }

    public static TemplateMode computeTemplateModeForContentType(String contentType) {
        if (contentType == null || contentType.trim().length() == 0) {
            return null;
        }
        ContentType contentTypeObj = ContentType.parseContentType(contentType);
        if (contentTypeObj == null) {
            return null;
        }
        String normalisedMimeType = NORMALIZED_MIME_TYPES.get(contentTypeObj.getMimeType());
        if (normalisedMimeType == null) {
            return null;
        }
        return TEMPLATE_MODE_BY_MIME_TYPE.get(normalisedMimeType);
    }

    public static TemplateMode computeTemplateModeForTemplateName(String templateName) {
        String fileExtension = ContentTypeUtils.computeFileExtensionFromTemplateName(templateName);
        if (fileExtension == null) {
            return null;
        }
        String mimeType = MIME_TYPE_BY_FILE_EXTENSION.get(fileExtension);
        if (mimeType == null) {
            return null;
        }
        return TEMPLATE_MODE_BY_MIME_TYPE.get(mimeType);
    }

    public static TemplateMode computeTemplateModeForRequestPath(String requestPath) {
        String fileExtension = ContentTypeUtils.computeFileExtensionFromRequestPath(requestPath);
        if (fileExtension == null) {
            return null;
        }
        String mimeType = MIME_TYPE_BY_FILE_EXTENSION.get(fileExtension);
        if (mimeType == null) {
            return null;
        }
        return TEMPLATE_MODE_BY_MIME_TYPE.get(mimeType);
    }

    public static boolean hasRecognizedFileExtension(String templateName) {
        String fileExtension = ContentTypeUtils.computeFileExtensionFromTemplateName(templateName);
        if (fileExtension == null) {
            return false;
        }
        return MIME_TYPE_BY_FILE_EXTENSION.containsKey(fileExtension);
    }

    public static String computeContentTypeForTemplateName(String templateName, Charset charset) {
        String fileExtension = ContentTypeUtils.computeFileExtensionFromTemplateName(templateName);
        if (fileExtension == null) {
            return null;
        }
        String mimeType = MIME_TYPE_BY_FILE_EXTENSION.get(fileExtension);
        if (mimeType == null) {
            return null;
        }
        ContentType contentType = ContentType.parseContentType(mimeType);
        if (contentType == null) {
            return null;
        }
        if (charset != null) {
            contentType.setCharset(charset);
        }
        return contentType.toString();
    }

    public static String computeContentTypeForRequestPath(String requestPath, Charset charset) {
        String fileExtension = ContentTypeUtils.computeFileExtensionFromRequestPath(requestPath);
        if (fileExtension == null) {
            return null;
        }
        String mimeType = MIME_TYPE_BY_FILE_EXTENSION.get(fileExtension);
        if (mimeType == null) {
            return null;
        }
        ContentType contentType = ContentType.parseContentType(mimeType);
        if (contentType == null) {
            return null;
        }
        if (charset != null) {
            contentType.setCharset(charset);
        }
        return contentType.toString();
    }

    public static Charset computeCharsetFromContentType(String contentType) {
        if (contentType == null || contentType.trim().length() == 0) {
            return null;
        }
        ContentType contentTypeObj = ContentType.parseContentType(contentType);
        if (contentTypeObj == null) {
            return null;
        }
        return contentTypeObj.getCharset();
    }

    private static String computeFileExtensionFromTemplateName(String templateName) {
        if (templateName == null || templateName.trim().length() == 0) {
            return null;
        }
        int pointPos = templateName.lastIndexOf(46);
        if (pointPos < 0) {
            return null;
        }
        return templateName.substring(pointPos).toLowerCase(Locale.US).trim();
    }

    private static String computeFileExtensionFromRequestPath(String requestPath) {
        int dotPos;
        int slashPos;
        int semicolonPos;
        int hashPos;
        String path = requestPath;
        int questionMarkPos = path.indexOf(63);
        if (questionMarkPos != -1) {
            path = path.substring(0, questionMarkPos);
        }
        if ((hashPos = path.indexOf(35)) != -1) {
            path = path.substring(0, hashPos);
        }
        if ((semicolonPos = path.indexOf(59)) != -1) {
            path = path.substring(0, semicolonPos);
        }
        if ((slashPos = path.lastIndexOf(47)) != -1) {
            path = path.substring(slashPos + 1);
        }
        if ((dotPos = path.lastIndexOf(46)) != -1) {
            return path.substring(dotPos);
        }
        return null;
    }

    public static String combineContentTypeAndCharset(String contentType, Charset charset) {
        if (charset == null) {
            return contentType;
        }
        if (contentType == null || contentType.trim().length() == 0) {
            return null;
        }
        ContentType contentTypeObj = ContentType.parseContentType(contentType);
        if (contentTypeObj == null) {
            return null;
        }
        contentTypeObj.setCharset(charset);
        return contentTypeObj.toString();
    }

    private ContentTypeUtils() {
    }

    static {
        HashMap<String, String> normalizedMimeTypes = new HashMap<String, String>(20, 1.0f);
        for (String type : MIME_TYPES_HTML) {
            normalizedMimeTypes.put(type, MIME_TYPES_HTML[0]);
        }
        for (String type : MIME_TYPES_XML) {
            normalizedMimeTypes.put(type, MIME_TYPES_XML[0]);
        }
        for (String type : MIME_TYPES_RSS) {
            normalizedMimeTypes.put(type, MIME_TYPES_RSS[0]);
        }
        for (String type : MIME_TYPES_ATOM) {
            normalizedMimeTypes.put(type, MIME_TYPES_ATOM[0]);
        }
        for (String type : MIME_TYPES_JAVASCRIPT) {
            normalizedMimeTypes.put(type, MIME_TYPES_JAVASCRIPT[0]);
        }
        for (String type : MIME_TYPES_JSON) {
            normalizedMimeTypes.put(type, MIME_TYPES_JSON[0]);
        }
        for (String type : MIME_TYPES_CSS) {
            normalizedMimeTypes.put(type, MIME_TYPES_CSS[0]);
        }
        for (String type : MIME_TYPES_TEXT) {
            normalizedMimeTypes.put(type, MIME_TYPES_TEXT[0]);
        }
        for (String type : MIME_TYPES_SSE) {
            normalizedMimeTypes.put(type, MIME_TYPES_SSE[0]);
        }
        NORMALIZED_MIME_TYPES = Collections.unmodifiableMap(normalizedMimeTypes);
        HashMap<String, String> mimeTypesByExtension = new HashMap<String, String>(20, 1.0f);
        for (String type : FILE_EXTENSIONS_HTML) {
            mimeTypesByExtension.put(type, MIME_TYPES_HTML[0]);
        }
        for (String type : FILE_EXTENSIONS_XML) {
            mimeTypesByExtension.put(type, MIME_TYPES_XML[0]);
        }
        for (String type : FILE_EXTENSIONS_RSS) {
            mimeTypesByExtension.put(type, MIME_TYPES_RSS[0]);
        }
        for (String type : FILE_EXTENSIONS_ATOM) {
            mimeTypesByExtension.put(type, MIME_TYPES_ATOM[0]);
        }
        for (String type : FILE_EXTENSIONS_JAVASCRIPT) {
            mimeTypesByExtension.put(type, MIME_TYPES_JAVASCRIPT[0]);
        }
        for (String type : FILE_EXTENSIONS_JSON) {
            mimeTypesByExtension.put(type, MIME_TYPES_JSON[0]);
        }
        for (String type : FILE_EXTENSIONS_CSS) {
            mimeTypesByExtension.put(type, MIME_TYPES_CSS[0]);
        }
        for (String type : FILE_EXTENSIONS_TEXT) {
            mimeTypesByExtension.put(type, MIME_TYPES_TEXT[0]);
        }
        MIME_TYPE_BY_FILE_EXTENSION = Collections.unmodifiableMap(mimeTypesByExtension);
        HashMap<String, TemplateMode> templateModeByMimeType = new HashMap<String, TemplateMode>(10, 1.0f);
        templateModeByMimeType.put(MIME_TYPES_HTML[0], TemplateMode.HTML);
        templateModeByMimeType.put(MIME_TYPES_XML[0], TemplateMode.XML);
        templateModeByMimeType.put(MIME_TYPES_RSS[0], TemplateMode.XML);
        templateModeByMimeType.put(MIME_TYPES_ATOM[0], TemplateMode.XML);
        templateModeByMimeType.put(MIME_TYPES_JAVASCRIPT[0], TemplateMode.JAVASCRIPT);
        templateModeByMimeType.put(MIME_TYPES_JSON[0], TemplateMode.JAVASCRIPT);
        templateModeByMimeType.put(MIME_TYPES_CSS[0], TemplateMode.CSS);
        templateModeByMimeType.put(MIME_TYPES_TEXT[0], TemplateMode.TEXT);
        TEMPLATE_MODE_BY_MIME_TYPE = Collections.unmodifiableMap(templateModeByMimeType);
    }

    static class ContentType {
        private final String PARAMETER_CHARSET = "charset";
        private final String mimeType;
        private final LinkedHashMap<String, String> parameters;

        static ContentType parseContentType(String contentType) {
            if (contentType == null || contentType.trim().length() == 0) {
                return null;
            }
            String[] tokens = StringUtils.split(contentType, ";");
            String mimeType = tokens[0].toLowerCase(Locale.US).trim();
            if (tokens.length == 1) {
                return new ContentType(mimeType, new LinkedHashMap<String, String>(2, 1.0f));
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(2, 1.0f);
            for (int i = 1; i < tokens.length; ++i) {
                String token = tokens[i].toLowerCase(Locale.US).trim();
                int equalPos = token.indexOf(61);
                if (equalPos != -1) {
                    parameters.put(token.substring(0, equalPos).trim(), token.substring(equalPos + 1).trim());
                    continue;
                }
                parameters.put(token.trim(), "");
            }
            return new ContentType(mimeType, parameters);
        }

        ContentType(String mimeType, LinkedHashMap<String, String> parameters) {
            this.mimeType = mimeType;
            this.parameters = parameters;
        }

        String getMimeType() {
            return this.mimeType;
        }

        LinkedHashMap<String, String> getParameters() {
            return this.parameters;
        }

        Charset getCharset() {
            String charsetStr = this.parameters.get("charset");
            if (charsetStr == null) {
                return null;
            }
            try {
                return Charset.forName(charsetStr);
            }
            catch (UnsupportedCharsetException e) {
                return null;
            }
        }

        void setCharset(Charset charset) {
            if (charset != null) {
                this.parameters.put("charset", charset.name());
            }
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(this.mimeType);
            for (Map.Entry<String, String> parameterEntry : this.parameters.entrySet()) {
                strBuilder.append(';');
                strBuilder.append(parameterEntry.getKey());
                strBuilder.append('=');
                strBuilder.append(parameterEntry.getValue());
            }
            return strBuilder.toString();
        }
    }
}

