/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.metawidget;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fakereplace.api.ChangedClass;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.api.NewClassData;
import org.fakereplace.data.InstanceTracker;

public class MetawidgetClassChangeAware
implements ClassChangeAware {
    private static final Method remove;

    private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        if (clazz == Object.class) {
            throw new NoSuchFieldException();
        }
        try {
            return clazz.getDeclaredField(name);
        }
        catch (Exception exception) {
            return MetawidgetClassChangeAware.getField(clazz.getSuperclass(), name);
        }
    }

    public void afterChange(List<ChangedClass> changed, List<NewClassData> added) {
        Set data = InstanceTracker.get((String)"org.metawidget.inspector.impl.actionstyle.BaseActionStyle");
        for (Object i : data) {
            MetawidgetClassChangeAware.clearMap(changed, i, "mActionCache");
        }
        data = InstanceTracker.get((String)"org.metawidget.inspector.impl.propertystyle.BasePropertyStyle");
        for (Object i : data) {
            MetawidgetClassChangeAware.clearMap(changed, i, "mPropertiesCache");
        }
    }

    public static void clearMap(List<ChangedClass> changed, Object i, String cacheName) {
        try {
            Field f = MetawidgetClassChangeAware.getField(i.getClass(), cacheName);
            f.setAccessible(true);
            Object map = f.get(i);
            for (ChangedClass c : changed) {
                remove.invoke(map, c.getChangedClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            remove = Map.class.getMethod("remove", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

