/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.weld;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import org.fakereplace.api.ChangedClass;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.api.NewClassData;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.integration.weld.javassist.WeldProxyClassLoadingDelegate;

public class WeldClassChangeAware
implements ClassChangeAware {
    private static final Map<Object, Object> proxyFactories = new MapMaker().weakKeys().makeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterChange(List<ChangedClass> changed, List<NewClassData> added) {
        ClassLoader oldCl = null;
        WeldProxyClassLoadingDelegate.beginProxyRegeneration();
        try {
            HashSet<ChangedClass> changedClasses = new HashSet<ChangedClass>(changed);
            for (Object instance : proxyFactories.values()) {
                try {
                    Class<?> cp = instance.getClass();
                    while (!cp.getName().equals("org.jboss.weld.bean.proxy.ProxyFactory")) {
                        cp = cp.getSuperclass();
                    }
                    Field beanField = cp.getDeclaredField("bean");
                    beanField.setAccessible(true);
                    Method getProxy = instance.getClass().getMethod("getProxyClass", new Class[0]);
                    getProxy.setAccessible(true);
                    Bean bean = (Bean)beanField.get(instance);
                    for (ChangedClass clazz : changedClasses) {
                        if (!bean.getTypes().contains(clazz.getChangedClass())) continue;
                        Thread.currentThread().setContextClassLoader(bean.getBeanClass().getClassLoader());
                        getProxy.invoke(instance, new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            WeldProxyClassLoadingDelegate.endProxyRegeneration();
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public static void addProxyFactory(Object factory, Object bean) {
        proxyFactories.put(bean, factory);
    }
}

