/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.weld;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Set;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;
import org.fakereplace.integration.weld.WeldClassChangeAware;
import org.fakereplace.integration.weld.javassist.WeldProxyClassLoadingDelegate;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.VirtualToStaticManipulator;
import org.fakereplace.replacement.notification.ChangedClassImpl;
import org.fakereplace.transformation.FakereplaceTransformer;
import org.fakereplace.util.DescriptorUtils;

public class WeldClassTransformer
implements FakereplaceTransformer {
    private static final Logger log = Logger.getLogger(WeldClassTransformer.class);
    public static final String ORG_JBOSS_WELD_BEAN_PROXY_PROXY_FACTORY = "org.jboss.weld.bean.proxy.ProxyFactory";

    public boolean transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, ClassFile file, Set<Class<?>> classesToRetransform, ChangedClassImpl changedClass, Set<MethodInfo> modifiedMethods) throws IllegalClassFormatException, BadBytecode {
        if (file.getName().equals(ORG_JBOSS_WELD_BEAN_PROXY_PROXY_FACTORY)) {
            for (MethodInfo method : file.getMethods()) {
                if (method.getName().equals("createProxyClass")) {
                    modifiedMethods.add(method);
                    VirtualToStaticManipulator virtualToStaticManipulator = new VirtualToStaticManipulator();
                    virtualToStaticManipulator.replaceVirtualMethodInvokationWithStatic(ClassLoader.class.getName(), WeldProxyClassLoadingDelegate.class.getName(), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", "(Ljava/lang/ClassLoader;Ljava/lang/String;)Ljava/lang/Class;", loader);
                    virtualToStaticManipulator.replaceVirtualMethodInvokationWithStatic("org.jboss.weld.util.bytecode.ClassFileUtils", WeldProxyClassLoadingDelegate.class.getName(), "toClass", "(Lorg/jboss/classfilewriter/ClassFile;Ljava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;", "(Lorg/jboss/classfilewriter/ClassFile;Ljava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;", loader);
                    virtualToStaticManipulator.transformClass(file, loader, true, modifiedMethods);
                    return true;
                }
                if (!method.getName().equals("<init>")) continue;
                modifiedMethods.add(method);
                Integer beanArgument = null;
                int count = 1;
                for (String paramType : DescriptorUtils.descriptorStringToParameterArray((String)method.getDescriptor())) {
                    if (paramType.equals("Ljavax/enterprise/inject/spi/Bean")) {
                        beanArgument = count;
                        break;
                    }
                    if (paramType.equals("D") || paramType.equals("J")) {
                        count += 2;
                        continue;
                    }
                    ++count;
                }
                if (beanArgument == null) {
                    log.error("Constructor org.jboss.weld.bean.proxy.ProxyFactory.<init>" + method.getDescriptor() + " does not have a bean parameter, proxies produced by this factory will not be reloadable");
                    continue;
                }
                Bytecode code = new Bytecode(file.getConstPool());
                code.addAload(0);
                code.addAload(beanArgument.intValue());
                code.addInvokestatic(WeldClassChangeAware.class.getName(), "addProxyFactory", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                CodeIterator it = method.getCodeAttribute().iterator();
                it.skipConstructor();
                it.insert(code.get());
            }
        }
        return false;
    }
}

