/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.weld.javassist;

import java.lang.instrument.ClassDefinition;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import org.fakereplace.core.Agent;
import org.fakereplace.replacement.AddedClass;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;
import org.jboss.weld.util.bytecode.ClassFileUtils;

public class WeldProxyClassLoadingDelegate {
    private static final ThreadLocal<Boolean> MAGIC_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static final void beginProxyRegeneration() {
        MAGIC_IN_PROGRESS.set(true);
    }

    public static final void endProxyRegeneration() {
        MAGIC_IN_PROGRESS.remove();
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            throw new ClassNotFoundException("fakereplace");
        }
        return classLoader.loadClass(className);
    }

    public static Class toClass(ClassFile ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            try {
                Class<?> originalProxyClass = loader.loadClass(ct.getName());
                try {
                    ByteArrayDataOutputStream bs = new ByteArrayDataOutputStream();
                    ct.write(bs);
                    Agent.redefine((ClassDefinition[])new ClassDefinition[]{new ClassDefinition(originalProxyClass, bs.getBytes())}, (AddedClass[])new AddedClass[0]);
                    return originalProxyClass;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed " + ct.getName(), e);
                }
            }
            catch (ClassNotFoundException e) {
                return ClassFileUtils.toClass((ClassFile)ct, (ClassLoader)loader, (ProtectionDomain)domain);
            }
        }
        return ClassFileUtils.toClass((ClassFile)ct, (ClassLoader)loader, (ProtectionDomain)domain);
    }
}

