/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.util;

import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.MessageLists;

public class JavaConventions {
    private static final Pattern PACKAGE_NAME = Pattern.compile("(?:[\\p{L}_][\\p{L}\\p{N}_]*)(?:\\.[\\p{L}_][\\p{L}\\p{N}_]*)*");
    private static final Pattern NICE_PACKAGE_NAME = Pattern.compile("(?:[\\p{Ll}][\\p{L}\\p{N}]*)(?:\\.[\\p{Ll}][\\p{L}\\p{N}]*)*");
    private static final String MSG_CODE_PREFIX = JavaConventions.class.getSimpleName() + "_";
    private static final Set<String> FORBIDDEN_NAMES = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "_");
    public static final String MSG_CODE_INVALID_PACKAGE_NAME = MSG_CODE_PREFIX + "InvalidPackageName";
    public static final String MSG_CODE_DISCOURAGED_PACKAGE_NAME = MSG_CODE_PREFIX + "DiscouragedPackageName";
    public static final String MSG_CODE_INVALID_TYPE_NAME = MSG_CODE_PREFIX + "InvalidTypeName";
    public static final String MSG_CODE_DISCOURAGED_TYPE_NAME = MSG_CODE_PREFIX + "DiscouragedTypeName";

    private JavaConventions() {
    }

    public static MessageList validatePackageName(String name) {
        if (name == null) {
            return new MessageList(Message.newError((String)MSG_CODE_INVALID_PACKAGE_NAME, (String)"A package name must not be null"));
        }
        if (!PACKAGE_NAME.matcher(name).matches()) {
            return new MessageList(Message.newError((String)MSG_CODE_INVALID_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java package name", name)));
        }
        if (!NICE_PACKAGE_NAME.matcher(name).matches()) {
            return new MessageList(Message.newWarning((String)MSG_CODE_DISCOURAGED_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java package name", name)));
        }
        for (String packageName : name.split("\\.")) {
            if (!FORBIDDEN_NAMES.contains(packageName)) continue;
            return new MessageList(Message.newError((String)MSG_CODE_INVALID_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java package name", packageName)));
        }
        return MessageLists.emptyMessageList();
    }

    public static MessageList validateTypeName(String name) {
        int lastIndexOfSeparator = name.lastIndexOf(46);
        if (lastIndexOfSeparator > 0) {
            String packageName = name.substring(0, lastIndexOfSeparator);
            MessageList messageList = JavaConventions.validatePackageName(packageName);
            String unqualifiedName = name.substring(lastIndexOfSeparator + 1);
            messageList.add(JavaConventions.validateUnqualifiedTypeName(unqualifiedName));
            return messageList;
        }
        return JavaConventions.validateUnqualifiedTypeName(name);
    }

    public static MessageList validateUnqualifiedTypeName(String name) {
        MessageList messageList = new MessageList();
        char firstChar = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            messageList.add(Message.newError((String)MSG_CODE_INVALID_TYPE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java type name, because {1} is not a 'Java Letter'", name, Character.valueOf(firstChar))));
        } else {
            if (Character.isLowerCase(firstChar)) {
                messageList.add(Message.newWarning((String)MSG_CODE_DISCOURAGED_TYPE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java type name, because it starts with a lower case character", name)));
            }
            if ('$' == firstChar) {
                messageList.add(Message.newWarning((String)MSG_CODE_DISCOURAGED_TYPE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java type name, because it starts with '$'", name)));
            }
        }
        name.codePoints().skip(1L).forEach(c -> {
            if (!Character.isJavaIdentifierPart(c)) {
                messageList.add(Message.newError((String)MSG_CODE_INVALID_TYPE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java type name, because {1} is not a 'Java Letter or Digit'", name, Character.toString(c))));
            }
        });
        return messageList;
    }

    public static boolean validateName(String name, Runtime.Version sourceLevel) {
        return !name.contains(".") && SourceVersion.isName(name, JavaConventions.convertToSourceVersion(sourceLevel));
    }

    public static boolean validateName(String name) {
        return !name.contains(".") && SourceVersion.isName(name);
    }

    private static SourceVersion convertToSourceVersion(Runtime.Version rv) {
        return SourceVersion.valueOf("RELEASE_" + rv.feature());
    }
}

