/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction;

import java.util.Locale;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.AVersion;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.eclipse.EclipseImplementationProvider;
import org.faktorips.devtools.abstraction.plainjava.PlainJavaImplementationProvider;

public final class Abstractions {
    private static final AImplementation IMPLEMENTATION = Abstractions.get();
    private static final boolean ECLIPSE_RUNNING = IMPLEMENTATION.isEclipse();

    private Abstractions() {
    }

    private static AImplementation get() {
        EclipseImplementationProvider eclipseImplementationProvider = new EclipseImplementationProvider();
        return eclipseImplementationProvider.canRun() ? eclipseImplementationProvider.get() : new PlainJavaImplementationProvider().get();
    }

    public static boolean isEclipseRunning() {
        return ECLIPSE_RUNNING;
    }

    public static AWorkspace getWorkspace() {
        return IMPLEMENTATION.getWorkspace();
    }

    public static Locale getLocale() {
        return IMPLEMENTATION.getLocale();
    }

    public static AVersion getVersion() {
        return IMPLEMENTATION.getVersion();
    }

    public static ALog getLog() {
        return IMPLEMENTATION.getLog();
    }

    public static String getImplementationId() {
        return IMPLEMENTATION.getId();
    }

    static Wrappers.WrapperBuilder getWrapperBuilder(Object original) {
        return IMPLEMENTATION.getWrapperBuilder(original);
    }

    public static interface AImplementation {
        public String getId();

        public boolean isEclipse();

        public Wrappers.WrapperBuilder getWrapperBuilder(Object var1);

        public AWorkspace getWorkspace();

        public Locale getLocale();

        public AVersion getVersion();

        public ALog getLog();
    }
}

