/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.faktorips.devtools.abstraction.AAbstraction;
import org.faktorips.devtools.abstraction.AWrapper;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;

public class Wrappers {
    private Wrappers() {
    }

    public static WrapperBuilder wrap(Object original) {
        return Abstractions.getWrapperBuilder(original);
    }

    public static <T> WrapperBuilder wrapSupplier(CoreExceptionThrowingSupplier<T> supplier) {
        return Wrappers.get(() -> Wrappers.wrap(supplier.get()));
    }

    public static void run(CoreExceptionThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (CoreException e) {
            throw new IpsException(e.getMessage(), e);
        }
    }

    public static <T> T get(CoreExceptionThrowingSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (CoreException e) {
            throw new IpsException(e.getMessage(), e);
        }
    }

    @CheckForNull
    public static <T> T unwrap(@CheckForNull AAbstraction wrapper) {
        return wrapper == null ? null : (T)((AWrapper)wrapper).unwrap();
    }

    public static <A extends AAbstraction> ArrayUnwrapper<A> unwrap(A[] wrappers) {
        return new ArrayUnwrapper(wrappers);
    }

    public static CollectionUnwrapper unwrap(Collection<? extends AAbstraction> wrappers) {
        return new CollectionUnwrapper(wrappers);
    }

    public static class ArrayUnwrapper<A extends AAbstraction> {
        private final A[] wrappers;

        protected ArrayUnwrapper(A[] wrappers) {
            this.wrappers = wrappers;
        }

        public <T> T[] asArrayOf(Class<T> clazz) {
            return this.wrappers == null ? null : Arrays.stream(this.wrappers).map(p -> p.unwrap()).toArray(l -> (Object[])Array.newInstance(clazz, l));
        }

        public <T> List<T> asList() {
            return this.wrappers == null ? null : Arrays.stream(this.wrappers).map(p -> p.unwrap()).collect(Collectors.toList());
        }
    }

    public static class CollectionUnwrapper {
        private final Collection<? extends AAbstraction> wrappers;

        protected CollectionUnwrapper(Collection<? extends AAbstraction> wrappers) {
            this.wrappers = wrappers;
        }

        public <T> T[] asArrayOf(Class<T> clazz) {
            return this.wrappers == null ? null : this.wrappers.stream().map(p -> p.unwrap()).toArray(l -> (Object[])Array.newInstance(clazz, l));
        }
    }

    @FunctionalInterface
    public static interface CoreExceptionThrowingRunnable {
        public void run() throws CoreException;
    }

    @FunctionalInterface
    public static interface CoreExceptionThrowingSupplier<T> {
        public T get() throws CoreException;
    }

    public static abstract class WrapperBuilder {
        private static Map<Object, Set<AAbstraction>> wrappers = new WeakHashMap<Object, Set<AAbstraction>>();
        private final Object original;

        protected WrapperBuilder(Object original) {
            this.original = original;
        }

        protected abstract <A extends AAbstraction> A wrapInternal(Object var1, Class<A> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <A extends AAbstraction> A as(Class<A> abstractionClass) {
            Set abstractions;
            if (this.original == null) {
                return null;
            }
            Object object = wrappers;
            synchronized (object) {
                abstractions = wrappers.computeIfAbsent(this.original, $ -> new LinkedHashSet());
            }
            object = abstractions;
            synchronized (object) {
                for (AAbstraction abstraction : abstractions) {
                    if (!abstractionClass.isInstance(abstraction)) continue;
                    AAbstraction wrapper = abstraction;
                    return (A)wrapper;
                }
                A wrapper = this.wrapInternal(this.original, abstractionClass);
                abstractions.add(wrapper);
                return wrapper;
            }
        }

        public <A extends AAbstraction> A[] asArrayOf(Class<A> abstraction) {
            AAbstraction[] wrapperArray = (AAbstraction[])Arrays.stream((Object[])this.original).map(o -> Wrappers.wrap(o).as(abstraction)).toArray(l -> (AAbstraction[])Array.newInstance(abstraction, l));
            return wrapperArray;
        }

        public <A extends AAbstraction> Set<A> asSetOf(Class<A> aClass) {
            return Arrays.stream((Object[])this.original).map(o -> Wrappers.wrap(o).as(aClass)).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public <A extends AAbstraction & Comparable<A>> SortedSet<A> asSortedSetOf(Class<A> aClass) {
            return Arrays.stream((Object[])this.original).map(o -> Wrappers.wrap(o).as(aClass)).collect(Collectors.toCollection(TreeSet::new));
        }
    }
}

