/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.eclipse.internal.EclipseResource;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.util.IoUtil;

public class EclipseFile
extends EclipseResource
implements AFile {
    protected EclipseFile(IFile file) {
        super((IResource)file);
    }

    @Override
    public IFile unwrap() {
        return (IFile)super.unwrap();
    }

    IFile file() {
        return this.unwrap();
    }

    @Override
    public void create(InputStream source, IProgressMonitor monitor) {
        Wrappers.run(() -> this.file().create(source, true, monitor));
    }

    @Override
    public InputStream getContents() {
        return Wrappers.get(() -> this.file().getContents(true));
    }

    @Override
    public void setContents(InputStream source, boolean keepHistory, IProgressMonitor monitor) {
        try {
            try {
                IFile file = this.file();
                if (!file.isReadOnly() || file.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT).isOK()) {
                    file.setContents(source, true, keepHistory, monitor);
                } else {
                    Abstractions.getLog().log((IStatus)new Status(4, "org.faktorips.devtools.abstraction.eclipse", "Cannot write to file " + file.getFullPath() + ". Maybe it is locked or readonly."));
                }
            }
            catch (CoreException e) {
                throw new IpsException(e);
            }
        }
        finally {
            IoUtil.close((Closeable)source);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.file().isReadOnly();
    }

    @Override
    public String getExtension() {
        String extension = this.file().getFileExtension();
        return extension == null ? "" : extension;
    }
}

