/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.AVersion;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.eclipse.internal.EclipseWrapperBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class EclipseImplementation
implements Abstractions.AImplementation,
BundleActivator {
    public static final String PLUGIN_ID = "org.faktorips.devtools.abstraction.eclipse";
    @CheckForNull
    private static EclipseImplementation instance;
    private Bundle bundle;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}) EclipseImplementation() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
    }

    public void stop(BundleContext context) throws Exception {
        this.bundle = null;
    }

    public static EclipseImplementation get() {
        return Objects.requireNonNull(instance, "Plugin org.faktorips.devtools.abstraction.eclipse was not activated yet.");
    }

    public static boolean isStarted() {
        return instance != null;
    }

    @Override
    public boolean isEclipse() {
        return true;
    }

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    @Override
    public Wrappers.WrapperBuilder getWrapperBuilder(Object original) {
        return new EclipseWrapperBuilder(original);
    }

    @Override
    public AWorkspace getWorkspace() {
        return Wrappers.wrap(ResourcesPlugin.getWorkspace()).as(AWorkspace.class);
    }

    @Override
    public Locale getLocale() {
        String nl = Platform.getNL();
        if (nl.length() > 2) {
            nl = nl.substring(0, 2);
        }
        return new Locale(nl);
    }

    @Override
    public AVersion getVersion() {
        String bundleVersion = (String)Platform.getBundle((String)"org.faktorips.devtools.model").getHeaders().get("Bundle-Version");
        return AVersion.parse(bundleVersion);
    }

    @Override
    public ALog getLog() {
        return Wrappers.wrap(Platform.getLog((Bundle)EclipseImplementation.get().bundle)).as(ALog.class);
    }
}

