/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.eclipse.internal.EclipseJavaElement;
import org.faktorips.devtools.abstraction.eclipse.internal.EclipseResource;
import org.faktorips.devtools.abstraction.eclipse.internal.Messages;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.mapping.PathMapping;
import org.faktorips.devtools.abstraction.mapping.SeverityMapping;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.MessageLists;
import org.faktorips.runtime.Severity;

public class EclipseJavaProject
extends EclipseJavaElement
implements AJavaProject {
    public static final String MSGCODE_JAVA_PROJECT_HAS_BUILDPATH_ERRORS = "IPSPROJECT-JavaProjectHasBuildPathErrors";

    EclipseJavaProject(IJavaProject javaProject) {
        super((IJavaElement)javaProject);
    }

    @Override
    public IJavaProject unwrap() {
        return (IJavaProject)super.unwrap();
    }

    IJavaProject javaProject() {
        return this.unwrap();
    }

    @Override
    public boolean exists() {
        return this.javaProject().exists();
    }

    @Override
    public Path getOutputLocation() {
        return Wrappers.get(() -> ((IJavaProject)this.javaProject()).getOutputLocation()).toFile().toPath();
    }

    @Override
    public APackageFragmentRoot toPackageFragmentRoot(String externalLibraryPath) {
        IPackageFragmentRoot packageFragmentRoot = this.javaProject().getPackageFragmentRoot(externalLibraryPath);
        return Wrappers.wrap(packageFragmentRoot).as(APackageFragmentRoot.class);
    }

    @Override
    public APackageFragmentRoot toPackageFragmentRoot(AResource resource) {
        IPackageFragmentRoot packageFragmentRoot = this.javaProject().getPackageFragmentRoot(((EclipseResource)resource).unwrap());
        return Wrappers.wrap(packageFragmentRoot).as(APackageFragmentRoot.class);
    }

    @Override
    public AProject getProject() {
        return this.getResource().getProject();
    }

    @Override
    public boolean hasBuildState() {
        return this.javaProject().hasBuildState();
    }

    @Override
    public Runtime.Version getSourceVersion() {
        String compilerCompliance = this.javaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return Runtime.Version.parse(compilerCompliance);
    }

    @Override
    public Set<AJavaProject> getReferencedJavaProjects() {
        LinkedHashSet<AJavaProject> result = new LinkedHashSet<AJavaProject>();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = this.javaProject().getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entrie = iClasspathEntryArray[n2];
                if (entrie.getEntryKind() == 2) {
                    IJavaProject refProject = this.javaProject().getJavaModel().getJavaProject(entrie.getPath().lastSegment());
                    result.add(Wrappers.wrap(refProject).as(AJavaProject.class));
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw new IpsException(e.getMessage(), (CoreException)((Object)e));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isJavaFolder(AResource resource) {
        try {
            IClasspathEntry[] entries;
            IPath outputPath = this.javaProject().getOutputLocation();
            IPath relativePath = PathMapping.toEclipsePath(resource.getWorkspaceRelativePath());
            if (Objects.equals(outputPath, relativePath)) {
                return true;
            }
            IClasspathEntry[] iClasspathEntryArray = entries = this.javaProject().getResolvedClasspath(true);
            int n = entries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (Objects.equals(entry.getOutputLocation(), relativePath)) {
                    return true;
                }
                if (Objects.equals(entry.getPath(), relativePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Abstractions.getLog().log(e);
            return false;
        }
    }

    @Override
    public MessageList validateJavaProjectBuildPath() {
        MessageList result = new MessageList();
        if (!this.exists()) {
            return result;
        }
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = this.javaProject().getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (this.validateClasspathEntry(this.javaProject(), entry, false).containsErrorMsg()) {
                    String text = MessageFormat.format(Messages.IpsProject_javaProjectHasInvalidBuildPath, entry.getPath());
                    Message msg = new Message(MSGCODE_JAVA_PROJECT_HAS_BUILDPATH_ERRORS, text, Message.WARNING, (Object)this);
                    result.add(msg);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            throw new IpsException(e.getMessage(), (CoreException)((Object)e));
        }
        return result;
    }

    private MessageList validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment) {
        IJavaModelStatus status = JavaConventions.validateClasspathEntry((IJavaProject)project, (IClasspathEntry)entry, (boolean)checkSourceAttachment);
        if (status.isOK()) {
            return MessageLists.emptyMessageList();
        }
        Severity severity = SeverityMapping.toIps(status.getSeverity());
        String message = status.getMessage();
        String code = Integer.toString(status.getCode());
        return MessageList.of((Message[])new Message[]{new Message(code, message, severity)});
    }

    @Override
    public Map<String, String> getOptions() {
        return this.javaProject().getOptions(true);
    }

    @Override
    public Set<APackageFragmentRoot> getAllPackageFragmentRoots() {
        try {
            return Arrays.stream(this.javaProject().getAllPackageFragmentRoots()).map(p -> Wrappers.wrap(p).as(APackageFragmentRoot.class)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (JavaModelException e) {
            throw new IpsException(e.getMessage(), (CoreException)((Object)e));
        }
    }
}

