/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import java.nio.charset.Charset;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.eclipse.internal.EclipseContainer;
import org.faktorips.devtools.abstraction.mapping.BuildKindMapping;

public class EclipseProject
extends EclipseContainer
implements AProject {
    private static final String NATURE_ID = "org.faktorips.devtools.model.ipsnature";
    private static final String OLD_NATURE_ID = "org.faktorips.devtools.core.ipsnature";

    EclipseProject(IProject project) {
        super((IContainer)project);
    }

    @Override
    public IProject unwrap() {
        return (IProject)super.unwrap();
    }

    public IProject project() {
        return this.unwrap();
    }

    @Override
    public AFile getFile(String name) {
        return Wrappers.wrap(this.project().getFile(name)).as(AFile.class);
    }

    @Override
    public AFolder getFolder(String name) {
        return Wrappers.wrap(this.project().getFolder(name)).as(AFolder.class);
    }

    @Override
    public Set<AProject> getReferencedProjects() {
        return Wrappers.wrapSupplier(() -> ((IProject)this.project()).getReferencedProjects()).asSetOf(AProject.class);
    }

    @Override
    public void delete(IProgressMonitor monitor) {
        Wrappers.run(() -> this.project().delete(true, true, monitor));
    }

    @Override
    public boolean isIpsProject() {
        return Wrappers.get(() -> this.project().isOpen() && (this.project().hasNature(NATURE_ID) || this.project().hasNature(OLD_NATURE_ID)));
    }

    @Override
    public void build(ABuildKind kind, IProgressMonitor monitor) {
        Wrappers.run(() -> this.project().build(BuildKindMapping.buildKind(kind), monitor));
    }

    @Override
    public Charset getDefaultCharset() {
        return Wrappers.get(() -> Charset.forName(this.project().getDefaultCharset()));
    }
}

