/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import java.nio.file.Path;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AMarker;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.AWrapper;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.mapping.PathMapping;

public abstract class EclipseResource
extends AWrapper<IResource>
implements AResource,
IAdaptable {
    protected EclipseResource(IResource resource) {
        super(resource);
    }

    @Override
    public IResource unwrap() {
        return (IResource)super.unwrap();
    }

    IResource resource() {
        return this.unwrap();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)this.resource().getAdapter(adapter);
    }

    @Override
    public boolean isAccessible() {
        return this.resource().isAccessible();
    }

    @Override
    public boolean exists() {
        return this.resource().exists();
    }

    @Override
    public AContainer getParent() {
        return Wrappers.wrap(this.resource().getParent()).as(AContainer.class);
    }

    @Override
    public String getName() {
        return this.resource().getName();
    }

    @Override
    public Path getLocation() {
        IPath location = this.resource().getLocation();
        return location == null ? null : location.toFile().toPath();
    }

    @Override
    public Path getProjectRelativePath() {
        return this.resource().getProjectRelativePath().toFile().toPath();
    }

    @Override
    public Path getWorkspaceRelativePath() {
        return this.resource().getFullPath().toFile().toPath();
    }

    @Override
    public void delete(IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().delete(true, monitor));
    }

    @Override
    public long getModificationStamp() {
        return this.resource().getModificationStamp();
    }

    @Override
    public long getLocalTimeStamp() {
        return this.resource().getLocalTimeStamp();
    }

    @Override
    public AResource.AResourceType getType() {
        int type = this.resource().getType();
        switch (type) {
            case 1: {
                return AResource.AResourceType.FILE;
            }
            case 2: {
                return AResource.AResourceType.FOLDER;
            }
            case 4: {
                return AResource.AResourceType.PROJECT;
            }
            case 8: {
                return AResource.AResourceType.WORKSPACE;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalStateException(String.valueOf(this.getName()) + " uses the undefined resource type " + type);
    }

    @Override
    public Set<AMarker> findMarkers(String type, boolean includeSubtypes, AResource.AResourceTreeTraversalDepth depth) {
        return Wrappers.wrapSupplier(() -> this.resource().findMarkers(type, includeSubtypes, EclipseResource.to(depth))).asSetOf(AMarker.class);
    }

    @Override
    public AMarker createMarker(String markerType) {
        return Wrappers.wrapSupplier(() -> this.resource().createMarker(markerType)).as(AMarker.class);
    }

    @Override
    public void deleteMarkers(String type, boolean includeSubtypes, AResource.AResourceTreeTraversalDepth depth) {
        Wrappers.run(() -> this.resource().deleteMarkers(type, includeSubtypes, EclipseResource.to(depth)));
    }

    @Override
    public boolean isDerived() {
        return this.resource().isDerived();
    }

    @Override
    public void setDerived(boolean isDerived, IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().setDerived(isDerived, monitor));
    }

    @Override
    public AProject getProject() {
        return Wrappers.wrap(this.resource().getProject()).as(AProject.class);
    }

    @Override
    public void refreshLocal(AResource.AResourceTreeTraversalDepth depth, IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().refreshLocal(EclipseResource.to(depth), monitor));
    }

    @Override
    public AWorkspace getWorkspace() {
        return Wrappers.wrap(this.resource().getWorkspace()).as(AWorkspace.class);
    }

    @Override
    public void copy(Path destination, IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().copy(PathMapping.toEclipsePath(destination), true, monitor));
    }

    @Override
    public void move(Path destination, IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().move(PathMapping.toEclipsePath(destination), true, monitor));
    }

    @Override
    public void touch(IProgressMonitor monitor) {
        Wrappers.run(() -> this.resource().touch(monitor));
    }

    @Override
    public boolean isSynchronized(AResource.AResourceTreeTraversalDepth depth) {
        return this.resource().isSynchronized(EclipseResource.to(depth));
    }

    private static int to(AResource.AResourceTreeTraversalDepth depth) {
        switch (depth) {
            case RESOURCE_ONLY: {
                return 0;
            }
            case RESOURCE_AND_DIRECT_MEMBERS: {
                return 1;
            }
            case INFINITE: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unknown depth: " + (Object)((Object)depth));
    }
}

