/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.eclipse.internal;

import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.AResourceDeltaVisitor;
import org.faktorips.devtools.abstraction.AWrapper;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.exception.IpsException;

public class EclipseResourceDelta
extends AWrapper<IResourceDelta>
implements AResourceDelta {
    public EclipseResourceDelta(IResourceDelta resourceDelta) {
        super(resourceDelta);
    }

    @Override
    public IResourceDelta unwrap() {
        return (IResourceDelta)super.unwrap();
    }

    IResourceDelta resourceDelta() {
        return this.unwrap();
    }

    @Override
    public AResourceDelta findMember(IPath path) {
        return Wrappers.wrap(this.resourceDelta().findMember(path)).as(AResourceDelta.class);
    }

    @Override
    public AResource getResource() {
        return Wrappers.wrap(this.resourceDelta().getResource()).as(AResource.class);
    }

    @Override
    public AResourceDelta.AResourceDeltaKind getKind() {
        int kind = this.resourceDelta().getKind();
        switch (kind) {
            case 1: {
                return AResourceDelta.AResourceDeltaKind.ADDED;
            }
            case 2: {
                return AResourceDelta.AResourceDeltaKind.REMOVED;
            }
        }
        return AResourceDelta.AResourceDeltaKind.CHANGED;
    }

    @Override
    public int getFlags() {
        return this.resourceDelta().getFlags();
    }

    @Override
    public void accept(final AResourceDeltaVisitor visitor) {
        try {
            this.resourceDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    return visitor.visit(new EclipseResourceDelta(delta));
                }
            });
        }
        catch (CoreException e) {
            throw new IpsException(e);
        }
    }
}

