/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFileUtil;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResource;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspaceRoot;

public abstract class PlainJavaContainer
extends PlainJavaResource
implements AContainer {
    private volatile SortedSet<PlainJavaResource> members;

    public PlainJavaContainer(File directory) {
        super(PlainJavaFileUtil.directory(directory));
    }

    File directory() {
        return (File)this.unwrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<PlainJavaResource> getMembers() {
        if (this.members == null) {
            PlainJavaContainer plainJavaContainer = this;
            synchronized (plainJavaContainer) {
                if (this.members == null) {
                    this.members = this.findMembers();
                }
            }
        }
        return new TreeSet<PlainJavaResource>(this.members);
    }

    private SortedSet<PlainJavaResource> findMembers() {
        File[] files = this.directory().listFiles();
        if (files == null) {
            return Collections.emptySortedSet();
        }
        PlainJavaWorkspaceRoot root = this.getWorkspace().getRoot();
        return Arrays.stream(files).map(File::toPath).map(root::get).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public AResource findMember(String path) {
        return this.getWorkspace().getRoot().get(this.directory().toPath().resolve(path));
    }

    @Override
    public AFile getFile(Path path) {
        return this.getWorkspace().getRoot().file(this.directory().toPath().resolve(path));
    }

    @Override
    public AFolder getFolder(Path path) {
        return this.getWorkspace().getRoot().folder(this.directory().toPath().resolve(path));
    }

    @Override
    protected void refreshInternal() {
        this.members = null;
        super.refreshInternal();
    }

    @Override
    protected boolean isSynchronizedInternal() {
        return super.isSynchronizedInternal() && Objects.equals(this.members, this.findMembers());
    }

    @Override
    protected void recursive(Consumer<PlainJavaResource> consumer, AResource.AResourceTreeTraversalDepth depth) {
        super.recursive(consumer, depth);
        if (depth != AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY) {
            for (PlainJavaResource resource : this.getMembers()) {
                resource.recursive(consumer, depth.decrement());
            }
        }
    }
}

