/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.MessageLists;

public class PlainJavaConventions {
    private static final Pattern PACKAGE_NAME = Pattern.compile("([a-zA-Z_]\\w*)(\\.[a-zA-Z_]\\w*)*");
    private static final Pattern NICE_PACKAGE_NAME = Pattern.compile("([a-z]\\w*)(\\.[a-z]\\w*)*");
    private static final String MSG_CODE_PREFIX = String.valueOf(PlainJavaConventions.class.getSimpleName()) + '_';
    private static final Set<String> FORBIDDEN_NAMES = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "_");
    public static final String MSG_CODE_INVALID_PACKAGE_NAME = String.valueOf(MSG_CODE_PREFIX) + "InvalidPackageName";
    public static final String MSG_CODE_DISCOURAGED_PACKAGE_NAME = String.valueOf(MSG_CODE_PREFIX) + "DiscouragedPackageName";
    public static final String MSG_CODE_INVALID_TYPE_NAME = String.valueOf(MSG_CODE_PREFIX) + "InvalidTypeName";
    public static final String MSG_CODE_DISCOURAGED_TYPE_NAME = String.valueOf(MSG_CODE_PREFIX) + "DiscouragedTypeName";

    private PlainJavaConventions() {
    }

    public static MessageList validatePackageName(String name) {
        Matcher packageNameMatcher = PACKAGE_NAME.matcher(name);
        if (!packageNameMatcher.matches()) {
            return new MessageList(Message.newError((String)MSG_CODE_INVALID_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java package name", name)));
        }
        if (!NICE_PACKAGE_NAME.matcher(name).matches()) {
            return new MessageList(Message.newWarning((String)MSG_CODE_DISCOURAGED_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java package name", name)));
        }
        String[] stringArray = name.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            if (FORBIDDEN_NAMES.contains(packageName)) {
                return new MessageList(Message.newError((String)MSG_CODE_INVALID_PACKAGE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java package name", packageName)));
            }
            ++n2;
        }
        return MessageLists.emptyMessageList();
    }

    public static MessageList validateTypeName(String name) {
        int lastIndexOfSeparator = name.lastIndexOf(46);
        if (lastIndexOfSeparator > 0) {
            String packageName = name.substring(0, lastIndexOfSeparator);
            MessageList messageList = PlainJavaConventions.validatePackageName(packageName);
            String unqualifiedName = name.substring(lastIndexOfSeparator + 1);
            messageList.add(PlainJavaConventions.validateUnqualifiedTypeName(unqualifiedName));
            return messageList;
        }
        return PlainJavaConventions.validateUnqualifiedTypeName(name);
    }

    public static MessageList validateUnqualifiedTypeName(String name) {
        MessageList messageList = new MessageList();
        char firstChar = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            messageList.add(Message.newError((String)MSG_CODE_INVALID_TYPE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java type name, because {1} is not a 'Java Letter'", name, Character.valueOf(firstChar))));
        } else {
            if (Character.isLowerCase(firstChar)) {
                messageList.add(Message.newWarning((String)MSG_CODE_DISCOURAGED_TYPE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java type name, because it starts with a lower case character", name)));
            }
            if ('$' == firstChar) {
                messageList.add(Message.newWarning((String)MSG_CODE_DISCOURAGED_TYPE_NAME, (String)MessageFormat.format("''{0}'' is discouraged as a Java type name, because it starts with '$'", name)));
            }
        }
        name.codePoints().skip(1L).forEach(c -> {
            if (!Character.isJavaIdentifierPart(c)) {
                messageList.add(Message.newError((String)MSG_CODE_INVALID_TYPE_NAME, (String)MessageFormat.format("''{0}'' is not allowed as a Java type name, because {1} is not a 'Java Letter or Digit'", name, Character.toString(c))));
            }
        });
        return messageList;
    }
}

