/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFileUtil;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaImplementation;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResource;

public class PlainJavaFile
extends PlainJavaResource
implements AFile {
    public PlainJavaFile(File file) {
        super(file);
    }

    @Override
    public AResource.AResourceType getType() {
        return AResource.AResourceType.FILE;
    }

    @Override
    void create() {
        try {
            this.file().createNewFile();
            this.refreshParent();
        }
        catch (IOException e) {
            throw new IpsException("Creating " + this.file() + " failed", e);
        }
    }

    @Override
    public void create(InputStream source, IProgressMonitor monitor) {
        PlainJavaFileUtil.withMonitor(this.file(), monitor, "Creating", p -> {
            p.getParent().toFile().mkdirs();
            if (source == null) {
                File file = p.toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
            } else {
                Files.copy(source, p, StandardCopyOption.REPLACE_EXISTING);
            }
        });
        this.refreshParent();
        PlainJavaImplementation.getResourceChanges().resourceCreated(this);
    }

    @Override
    public InputStream getContents() {
        try {
            return new FileInputStream(this.file());
        }
        catch (FileNotFoundException e) {
            throw new IpsException("Can't read " + this.file(), e);
        }
    }

    @Override
    public void setContents(InputStream source, boolean keepHistory, IProgressMonitor monitor) {
        long previousModificationStamp = this.getModificationStamp();
        PlainJavaFileUtil.withMonitor(this.file(), monitor, "Writing", p -> {
            long l = Files.copy(source, p, StandardCopyOption.REPLACE_EXISTING);
        });
        this.ensureNewModificationStamp(previousModificationStamp);
        PlainJavaImplementation.getResourceChanges().resourceChanged(this);
    }

    private void ensureNewModificationStamp(long previousModificationStamp) {
        int i = 1;
        while (previousModificationStamp == this.getModificationStamp()) {
            try {
                Thread.sleep(i);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            this.touch(null);
            i *= 10;
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getExtension() {
        String name = this.getName();
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod > 0) {
            return name.substring(lastPeriod + 1);
        }
        return "";
    }
}

