/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaImplementation;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaProject;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspaceRoot;

public class PlainJavaFileUtil {
    private PlainJavaFileUtil() {
    }

    public static File copy(File file, Path destination, IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                PlainJavaFileUtil.initializeAndStartMonitor(file, monitor, "Copying");
            }
            File copy = PlainJavaFileUtil.makeAbsolute(file, destination).toFile();
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)copy);
            } else {
                FileUtils.copyFile((File)file, (File)copy);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            File file2 = copy;
            return file2;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IpsException("Copying " + file + " failed", e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static Path makeAbsolute(File file, Path destination) {
        PlainJavaWorkspaceRoot workspaceRoot = PlainJavaImplementation.get().getWorkspace().getRoot();
        if (workspaceRoot.getProjects().stream().anyMatch(p -> destination.startsWith(p.getWorkspaceRelativePath()))) {
            Path workspacePath = workspaceRoot.getLocation();
            return workspacePath.resolve(destination);
        }
        Path parentDir = file.toPath().toAbsolutePath().getParent();
        return parentDir == null ? destination : parentDir.resolve(destination);
    }

    public static void move(File file, Path destination, IProgressMonitor monitor) {
        try {
            try {
                if (monitor != null) {
                    PlainJavaFileUtil.initializeAndStartMonitor(file, monitor, "Moving");
                }
                if (file.isDirectory()) {
                    FileUtils.moveDirectory((File)file, (File)PlainJavaFileUtil.makeAbsolute(file, destination).toFile());
                } else {
                    FileUtils.moveFile((File)file, (File)PlainJavaFileUtil.makeAbsolute(file, destination).toFile());
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                throw new IpsException("Moving " + file + " failed", e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static File directory(File potentialDirectory) {
        if (!potentialDirectory.exists() || potentialDirectory.isDirectory()) {
            return potentialDirectory;
        }
        throw new IllegalArgumentException(potentialDirectory + " is not a directory");
    }

    public static File internalResource(File potentialInternal, PlainJavaProject project) {
        if (potentialInternal.toPath().startsWith(project.getWorkspace().getRoot().directory().toPath().resolve(project.getWorkspaceRelativePath()))) {
            return potentialInternal;
        }
        throw new IllegalArgumentException(potentialInternal + " is not in the project: " + project.getName());
    }

    public static void walk(File file, IProgressMonitor monitor, String taskname, PathHandler pathHandler) {
        try {
            if (monitor != null) {
                PlainJavaFileUtil.initializeAndStartMonitor(file, monitor, taskname);
            }
            Files.walkFileTree(file.toPath(), new PathHandlerFileVisitor(pathHandler, monitor));
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (IOException e) {
            throw new IpsException(String.valueOf(taskname) + " " + file + " failed", e);
        }
    }

    private static void initializeAndStartMonitor(File file, IProgressMonitor monitor, String taskname) throws IOException {
        final AtomicInteger count = new AtomicInteger(0);
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                count.incrementAndGet();
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                count.incrementAndGet();
                return super.postVisitDirectory(dir, exc);
            }
        });
        monitor.beginTask(String.valueOf(taskname) + " " + file, count.get());
    }

    public static void withMonitor(File file, IProgressMonitor monitor, String taskname, PathHandler pathHandler) {
        if (monitor != null) {
            monitor.beginTask(String.valueOf(taskname) + " " + file, 1);
        }
        try {
            pathHandler.handle(file.toPath());
        }
        catch (IOException e) {
            throw new IpsException(String.valueOf(taskname) + " " + file + " failed", e);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    @FunctionalInterface
    public static interface PathHandler {
        public void handle(Path var1) throws IOException;
    }

    private static final class PathHandlerFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PathHandler pathHandler;
        private final IProgressMonitor monitor;

        private PathHandlerFileVisitor(PathHandler pathHandler, IProgressMonitor monitor) {
            this.pathHandler = pathHandler;
            this.monitor = monitor;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.pathHandler.handle(file);
            if (this.monitor != null) {
                this.monitor.worked(1);
            }
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.pathHandler.handle(dir);
            if (this.monitor != null) {
                this.monitor.worked(1);
            }
            return super.postVisitDirectory(dir, exc);
        }
    }
}

