/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.ALogListener;
import org.faktorips.devtools.abstraction.AVersion;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaContainer;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResource;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResourceChange;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspace;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWrapperBuilder;

public enum PlainJavaImplementation implements Abstractions.AImplementation
{
    INSTANCE;

    static final String ID = "Plain Java Faktor-IPS";
    private final Locale locale = Locale.getDefault();
    private volatile PlainJavaWorkspace workspace;
    private final ALog log = new PlainJavaLog();
    private final ResourceChanges resourceChanges = new ResourceChanges();

    static PlainJavaImplementation get() {
        return INSTANCE;
    }

    private static File createTmpWorkspaceDirectory() {
        try {
            return Files.createTempDirectory("Workspace", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IpsException("Could not create temporary workspace directory", e);
        }
    }

    public void setWorkspace(PlainJavaWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public boolean isEclipse() {
        return false;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Wrappers.WrapperBuilder getWrapperBuilder(Object original) {
        return new PlainJavaWrapperBuilder(original);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlainJavaWorkspace getWorkspace() {
        PlainJavaWorkspace result = this.workspace;
        if (result == null) {
            PlainJavaImplementation plainJavaImplementation = this;
            synchronized (plainJavaImplementation) {
                if (this.workspace == null) {
                    this.workspace = result = new PlainJavaWorkspace(PlainJavaImplementation.createTmpWorkspaceDirectory());
                }
            }
        }
        return result;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public AVersion getVersion() {
        return AVersion.parse("21.12");
    }

    @Override
    public ALog getLog() {
        return this.log;
    }

    public static ResourceChanges getResourceChanges() {
        return PlainJavaImplementation.get().resourceChanges;
    }

    private static final class PlainJavaLog
    implements ALog {
        private final Map<ALogListener, Void> logListeners = new WeakHashMap<ALogListener, Void>();

        private PlainJavaLog() {
        }

        @Override
        public <T> T unwrap() {
            throw new UnsupportedOperationException(String.valueOf(PlainJavaLog.class.getSimpleName()) + " does not wrap a single object");
        }

        @Override
        public void addLogListener(ALogListener listener) {
            this.logListeners.put(listener, null);
        }

        @Override
        public void removeLogListener(ALogListener listener) {
            this.logListeners.remove(listener);
        }

        @Override
        public void log(IStatus status) {
            this.logListeners.keySet().forEach(l -> l.logging(status, PlainJavaImplementation.ID));
            if (status.getSeverity() == 4) {
                Logger.getLogger(PlainJavaImplementation.ID).log(Level.SEVERE, status.getMessage());
            } else if (status.getSeverity() == 2) {
                Logger.getLogger(PlainJavaImplementation.ID).log(Level.WARNING, status.getMessage());
            } else if (status.getSeverity() == 1) {
                Logger.getLogger(PlainJavaImplementation.ID).log(Level.INFO, status.getMessage());
            } else {
                Logger.getLogger(PlainJavaImplementation.ID).log(Level.FINE, status.getMessage());
            }
        }
    }

    public static final class ResourceChanges {
        private final Set<Consumer<PlainJavaResourceChange>> resourceChangeListeners = new LinkedHashSet<Consumer<PlainJavaResourceChange>>();
        private final Deque<PlainJavaResourceChange> delayedChangeEvents = new LinkedList<PlainJavaResourceChange>();
        private boolean delayChangeEvents;

        void hold() {
            this.delayChangeEvents = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resume() {
            LinkedList<PlainJavaResourceChange> eventsToResend;
            Deque<PlainJavaResourceChange> deque = this.delayedChangeEvents;
            synchronized (deque) {
                eventsToResend = new LinkedList<PlainJavaResourceChange>(this.delayedChangeEvents);
                this.delayedChangeEvents.clear();
                this.delayChangeEvents = false;
            }
            eventsToResend.forEach(this::notifyResourceChangeListeners);
        }

        private void notifyResourceChangeListeners(PlainJavaResourceChange change) {
            if (this.delayChangeEvents) {
                this.delayedChangeEvents.add(change);
            } else {
                this.resourceChangeListeners.forEach(listener -> listener.accept(change));
            }
            PlainJavaResource changedResource = change.getChangedResource();
            if (changedResource instanceof PlainJavaContainer) {
                PlainJavaContainer container = (PlainJavaContainer)changedResource;
                container.getMembers().stream().map(r -> new PlainJavaResourceChange((PlainJavaResource)r, change.getType())).forEach(this::notifyResourceChangeListeners);
            }
        }

        public void resourceChanged(PlainJavaResource changedResource) {
            this.notifyResourceChangeListeners(new PlainJavaResourceChange(changedResource, PlainJavaResourceChange.Type.CONTENT_CHANGED));
        }

        public void resourceMoved(PlainJavaResource oldResource, PlainJavaResource newResource) {
            this.notifyResourceChangeListeners(new PlainJavaResourceChange(oldResource, PlainJavaResourceChange.Type.REMOVED));
            this.notifyResourceChangeListeners(new PlainJavaResourceChange(newResource, PlainJavaResourceChange.Type.ADDED));
        }

        public void resourceCreated(PlainJavaResource newResource) {
            this.notifyResourceChangeListeners(new PlainJavaResourceChange(newResource, PlainJavaResourceChange.Type.ADDED));
        }

        public void resourceRemoved(PlainJavaResource removedResource) {
            this.notifyResourceChangeListeners(new PlainJavaResourceChange(removedResource, PlainJavaResourceChange.Type.REMOVED));
        }

        public void addListener(Consumer<PlainJavaResourceChange> listener) {
            this.resourceChangeListeners.add(listener);
        }

        public void removeListener(Consumer<PlainJavaResourceChange> listener) {
            this.resourceChangeListeners.remove(listener);
        }
    }
}

