/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFileUtil;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaJavaElement;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaProject;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;

public class PlainJavaJavaProject
extends PlainJavaJavaElement
implements AJavaProject {
    private static final String TEST_FOLDER = "test";
    private static final String RESOURCES_FOLDER = "resources";
    private static final String JAVA_FOLDER = "java";
    private static final String MAIN_FOLDER = "main";
    private static final String SRC_FOLDER = "src";
    private final List<AFolder> folders = List.of(this.getProject().getFolder("src").getFolder("main").getFolder("java"), this.getProject().getFolder("src").getFolder("main").getFolder("resources"), this.getProject().getFolder("src").getFolder("test").getFolder("java"), this.getProject().getFolder("src").getFolder("test").getFolder("resources"));

    public PlainJavaJavaProject(File project) {
        super(project);
    }

    @Override
    public File unwrap() {
        return (File)super.unwrap();
    }

    File javaProject() {
        return this.unwrap();
    }

    @Override
    public AProject getProject() {
        return this.getResource().getProject();
    }

    @Override
    public boolean exists() {
        return this.getProject().exists();
    }

    @Override
    public boolean hasBuildState() {
        return false;
    }

    @Override
    public Path getOutputLocation() {
        return this.getProject().getWorkspaceRelativePath().resolve("target");
    }

    @Override
    public APackageFragmentRoot toPackageFragmentRoot(String externalLibraryPath) {
        return Wrappers.wrap(Path.of(externalLibraryPath, new String[0]).toFile()).as(APackageFragmentRoot.class);
    }

    @Override
    public APackageFragmentRoot toPackageFragmentRoot(AResource resource) {
        if (!AResource.AResourceType.FOLDER.equals((Object)resource.getType())) {
            throw new UnsupportedOperationException(resource + " is not a directory.");
        }
        return Wrappers.wrap(PlainJavaFileUtil.internalResource((File)resource.unwrap(), (PlainJavaProject)this.getProject())).as(APackageFragmentRoot.class);
    }

    @Override
    public Runtime.Version getSourceVersion() {
        return Runtime.version();
    }

    @Override
    public Set<AJavaProject> getReferencedJavaProjects() {
        return Set.of();
    }

    @Override
    public boolean isJavaFolder(AResource resource) {
        return Objects.equals(this.toPackageFragmentRoot(resource).unwrap(), resource.unwrap());
    }

    @Override
    public MessageList validateJavaProjectBuildPath() {
        return MessageList.of((Message[])new Message[0]);
    }

    @Override
    public Map<String, String> getOptions() {
        return Map.of();
    }

    @Override
    public Set<APackageFragmentRoot> getAllPackageFragmentRoots() {
        return this.folders.stream().map(p -> Wrappers.wrap(p).as(APackageFragmentRoot.class)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

