/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResource;
import org.faktorips.runtime.Severity;

public class PlainJavaMarkerImpl {
    public static final String SEVERITY = "severity";
    private final PlainJavaResource resource;
    private final String type;
    private final long id;
    private final Map<String, Object> attributes;

    public PlainJavaMarkerImpl(PlainJavaResource resource, String type) {
        this.resource = resource;
        this.type = type;
        this.id = resource.getWorkspace().getNextMarkerId();
        this.attributes = new LinkedHashMap<String, Object>();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.id);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PlainJavaMarkerImpl)) {
            return false;
        }
        PlainJavaMarkerImpl other = (PlainJavaMarkerImpl)obj;
        return this.id == other.id;
    }

    public boolean equalsType(String type) {
        if (this.type == null && type == null) {
            return true;
        }
        if (this.type == null || type == null) {
            return false;
        }
        return this.type.equals(type);
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Object value = this.attributes.get(attributeName);
        if (this.isAttributeSameTypeAsDefault(value, String.class)) {
            return (String)value;
        }
        return defaultValue;
    }

    private boolean isAttributeSameTypeAsDefault(Object value, Class<?> clazz) {
        return value != null && value.getClass().isAssignableFrom(clazz);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Object value = this.attributes.get(attributeName);
        if (this.isAttributeSameTypeAsDefault(value, Integer.class)) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Object value = this.attributes.get(attributeName);
        if (this.isAttributeSameTypeAsDefault(value, Boolean.class)) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public void setAttribute(String attributeName, Object value) {
        if (value == null) {
            this.attributes.remove(attributeName);
        } else {
            this.attributes.put(attributeName, value);
        }
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        if (Objects.requireNonNull(attributeNames, "attributeNames must not be null").length != Objects.requireNonNull(values, "values must not be null").length) {
            throw new IllegalArgumentException("The number of attribute names(" + attributeNames.length + ") does not match the number of values(" + values.length + ")");
        }
        int i = 0;
        while (i < attributeNames.length) {
            this.setAttribute(attributeNames[i], values[i]);
            ++i;
        }
    }

    public boolean isError() {
        return this.attributes.getOrDefault(SEVERITY, Severity.ERROR).equals(Severity.ERROR);
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public PlainJavaResource getResource() {
        return this.resource;
    }
}

