/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AMarker;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AWrapper;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaContainer;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFileUtil;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaImplementation;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaMarker;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaMarkerImpl;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspace;

public abstract class PlainJavaResource
extends AWrapper<File>
implements AResource {
    private Long lastModified;
    private volatile Set<PlainJavaMarker> markers = null;
    private boolean derived;

    public PlainJavaResource(File wrapped) {
        super(wrapped);
    }

    abstract void create();

    File file() {
        return (File)this.unwrap();
    }

    @Override
    public boolean isAccessible() {
        return this.exists();
    }

    @Override
    public boolean exists() {
        return this.file().exists();
    }

    @Override
    public AContainer getParent() {
        File parentFile = this.file().getParentFile();
        return parentFile == null ? null : (AContainer)((Object)this.getWorkspace().getRoot().get(parentFile.toPath()));
    }

    @Override
    public String getName() {
        return this.file().getName();
    }

    @Override
    public Path getLocation() {
        return this.file().toPath();
    }

    @Override
    public Path getProjectRelativePath() {
        File projectDirectory;
        AProject project = this.getProject();
        if (project != null && (projectDirectory = (File)project.unwrap()) != null) {
            return projectDirectory.toPath().relativize(this.file().toPath());
        }
        return Path.of("", new String[0]);
    }

    @Override
    public Path getWorkspaceRelativePath() {
        File workspaceDirectory;
        PlainJavaWorkspace workspace = this.getWorkspace();
        if (workspace != null && (workspaceDirectory = (File)workspace.unwrap()) != null) {
            return workspaceDirectory.toPath().relativize(this.file().toPath());
        }
        return Path.of("", new String[0]);
    }

    @Override
    public void delete(IProgressMonitor monitor) {
        if (this.file().exists()) {
            this.getWorkspace().getRoot().remove(this.file().toPath());
            this.clearMarkers();
            PlainJavaImplementation.getResourceChanges().hold();
            PlainJavaFileUtil.walk(this.file(), monitor, "Deleting", path -> {
                PlainJavaResource resource = (PlainJavaResource)Wrappers.wrap(path.toFile()).as(AResource.class);
                PlainJavaImplementation.getResourceChanges().resourceRemoved(resource);
                resource.refreshParent();
                Files.delete(path);
            });
            PlainJavaImplementation.getResourceChanges().resume();
        }
        this.refreshParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMarkers() {
        if (this.markers != null) {
            Set<PlainJavaMarker> set = this.markers;
            synchronized (set) {
                this.markers.clear();
            }
        }
    }

    void refreshParent() {
        AContainer parent = this.getParent();
        if (parent instanceof PlainJavaContainer) {
            ((PlainJavaContainer)parent).refreshInternal();
        }
    }

    @Override
    public long getModificationStamp() {
        this.lastModified = this.file().lastModified();
        return this.lastModified;
    }

    @Override
    public long getLocalTimeStamp() {
        return this.lastModified != null ? this.lastModified.longValue() : this.getModificationStamp();
    }

    @Override
    public Set<AMarker> findMarkers(String type, boolean includeSubtypes, AResource.AResourceTreeTraversalDepth depth) {
        LinkedHashSet<AMarker> foundMarkers = new LinkedHashSet<AMarker>();
        this.recursive(r -> r.findMarkersInternal(type, foundMarkers), depth);
        return foundMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMarkersInternal(String type, Set<AMarker> foundMarkers) {
        if (this.markers != null) {
            Set<PlainJavaMarker> set = this.markers;
            synchronized (set) {
                this.markers.stream().filter(m -> ((PlainJavaMarkerImpl)m.unwrap()).equalsType(type)).forEach(foundMarkers::add);
            }
        }
    }

    protected void recursive(Consumer<PlainJavaResource> consumer, AResource.AResourceTreeTraversalDepth depth) {
        consumer.accept(this);
    }

    protected void recursive(Consumer<PlainJavaResource> consumer, AResource.AResourceTreeTraversalDepth depth, @CheckForNull IProgressMonitor monitor, String taskName) {
        if (monitor == null) {
            this.recursive(consumer, depth);
        } else {
            AtomicInteger count = new AtomicInteger();
            this.recursive(r -> {
                int n = count.incrementAndGet();
            }, depth);
            monitor.beginTask(String.valueOf(taskName) + ' ' + this.getName(), count.get());
            this.recursive(resource -> {
                consumer.accept((PlainJavaResource)resource);
                monitor.internalWorked(1.0);
            }, depth);
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMarker createMarker(String markerType) {
        Object object;
        PlainJavaMarker marker = new PlainJavaMarker(this, markerType);
        if (this.markers == null) {
            object = this;
            synchronized (object) {
                if (this.markers == null) {
                    this.markers = new LinkedHashSet<PlainJavaMarker>();
                }
            }
        }
        object = this.markers;
        synchronized (object) {
            if (this.markers.add(marker)) {
                return marker;
            }
            return (AMarker)this.markers.stream().filter(Predicate.isEqual(marker)).findFirst().get();
        }
    }

    @Override
    public void deleteMarkers(String type, boolean includeSubtypes, AResource.AResourceTreeTraversalDepth depth) {
        this.recursive(r -> r.deletMarkersInternal(type), depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletMarkersInternal(String type) {
        if (this.markers != null) {
            Set<PlainJavaMarker> set = this.markers;
            synchronized (set) {
                Iterator<PlainJavaMarker> iterator = this.markers.iterator();
                while (iterator.hasNext()) {
                    PlainJavaMarkerImpl marker = (PlainJavaMarkerImpl)iterator.next().unwrap();
                    if (!marker.equalsType(type)) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMarker(PlainJavaMarker plainJavaMarker) {
        if (this.markers != null) {
            Set<PlainJavaMarker> set = this.markers;
            synchronized (set) {
                this.markers.remove(plainJavaMarker);
            }
        }
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public void setDerived(boolean isDerived, IProgressMonitor monitor) {
        PlainJavaFileUtil.walk(this.file(), monitor, "Marking as derived", p -> {
            boolean bl2 = this.getWorkspace().getRoot().get((Path)p).derived = isDerived;
        });
    }

    @Override
    public AProject getProject() {
        AResource resource = this;
        while (resource != null) {
            if (resource instanceof AProject) {
                return (AProject)resource;
            }
            resource = resource.getParent();
        }
        return null;
    }

    @Override
    public void refreshLocal(AResource.AResourceTreeTraversalDepth depth, IProgressMonitor monitor) {
        this.recursive(PlainJavaResource::refreshInternal, depth, monitor, "refreshing");
    }

    protected void refreshInternal() {
        this.getModificationStamp();
    }

    @Override
    public PlainJavaWorkspace getWorkspace() {
        return (PlainJavaWorkspace)Abstractions.getWorkspace();
    }

    @Override
    public void copy(Path destination, IProgressMonitor monitor) {
        File copy = PlainJavaFileUtil.copy(this.file(), destination, monitor);
        PlainJavaResource createdResource = (PlainJavaResource)Wrappers.wrap(copy).as(AResource.class);
        createdResource.refreshParent();
        PlainJavaImplementation.getResourceChanges().resourceCreated(createdResource);
    }

    @Override
    public void move(Path destination, IProgressMonitor monitor) {
        PlainJavaFileUtil.move(this.file(), destination, monitor);
        PlainJavaImplementation.getResourceChanges().resourceMoved(this, (PlainJavaResource)Wrappers.wrap(destination.toFile()).as(AResource.class));
    }

    @Override
    public void touch(IProgressMonitor monitor) {
        if (!this.exists()) {
            this.create();
        }
        this.file().setLastModified(System.currentTimeMillis());
    }

    @Override
    public boolean isSynchronized(AResource.AResourceTreeTraversalDepth depth) {
        AtomicBoolean isSynchronized = new AtomicBoolean(true);
        this.recursive(PlainJavaResource::isSynchronizedInternal, depth);
        return isSynchronized.get();
    }

    protected boolean isSynchronizedInternal() {
        return this.lastModified.longValue() == this.getLocalTimeStamp();
    }
}

