/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.AWrapper;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFileUtil;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaImplementation;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspaceRoot;

public class PlainJavaWorkspace
extends AWrapper<File>
implements AWorkspace {
    private final AtomicLong markerId = new AtomicLong();
    private final PlainJavaWorkspaceRoot root = new PlainJavaWorkspaceRoot(this);

    public PlainJavaWorkspace(File workspaceDirectory) {
        super(PlainJavaFileUtil.directory(workspaceDirectory));
    }

    File workspace() {
        return (File)this.unwrap();
    }

    @Override
    public PlainJavaWorkspaceRoot getRoot() {
        return this.root;
    }

    @Override
    public void run(ICoreRunnable action, IProgressMonitor monitor) {
        PlainJavaImplementation.getResourceChanges().hold();
        Wrappers.run(() -> action.run(monitor));
        PlainJavaImplementation.getResourceChanges().resume();
    }

    public long getNextMarkerId() {
        return this.markerId.getAndIncrement();
    }

    @Override
    public void build(ABuildKind buildKind, IProgressMonitor monitor) {
        this.getRoot().getProjects().forEach(p -> p.build(buildKind, monitor));
    }
}

