/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.plainjava.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AWorkspaceRoot;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaContainer;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFile;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaFolder;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaProject;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaResource;
import org.faktorips.devtools.abstraction.plainjava.internal.PlainJavaWorkspace;

public class PlainJavaWorkspaceRoot
extends PlainJavaFolder
implements AWorkspaceRoot {
    private PlainJavaWorkspace workspace;
    private final Map<Path, PlainJavaResource> resources = new ConcurrentHashMap<Path, PlainJavaResource>();

    public PlainJavaWorkspaceRoot(PlainJavaWorkspace workspace) {
        super((File)workspace.unwrap());
        this.workspace = workspace;
    }

    @Override
    public PlainJavaWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public AResource.AResourceType getType() {
        return AResource.AResourceType.WORKSPACE;
    }

    @Override
    public AProject getProject(String name) {
        return this.project(this.directory().toPath().resolve(name));
    }

    @Override
    public AFile getFileForLocation(Path location) {
        if (this.getProjects().stream().map(p -> (File)p.unwrap()).map(File::getAbsoluteFile).map(File::toPath).anyMatch(location::startsWith)) {
            return this.file(location);
        }
        return null;
    }

    @Override
    public Set<AProject> getProjects() {
        this.refreshInternal();
        return this.getMembers().stream().filter(PlainJavaFolder.class::isInstance).map(PlainJavaFolder.class::cast).map(PlainJavaContainer::directory).map(File::toPath).map(this::project).collect(Collectors.toCollection(() -> new TreeSet<AProject>(Comparator.comparing(AResource::getName))));
    }

    PlainJavaResource get(Path path) {
        Path absolutePath = path.isAbsolute() ? path : this.directory().toPath().resolve(path).toAbsolutePath();
        return this.resources.computeIfAbsent(absolutePath, p -> {
            File file = p.toFile();
            if (file.isDirectory() || !file.exists() && !file.getName().contains(".")) {
                if (file.equals(this.directory())) {
                    return this;
                }
                File parentFile = file.getParentFile();
                if (parentFile == null) {
                    return null;
                }
                if (parentFile.equals(this.directory())) {
                    return (PlainJavaProject)Wrappers.wrap(file).as(AProject.class);
                }
                return (PlainJavaFolder)Wrappers.wrap(file).as(AFolder.class);
            }
            return (PlainJavaFile)Wrappers.wrap(file).as(AFile.class);
        });
    }

    public void remove(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    PlainJavaWorkspaceRoot.this.resources.remove(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    PlainJavaWorkspaceRoot.this.resources.remove(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    PlainJavaFile file(Path path) {
        PlainJavaResource resource = this.resources.computeIfAbsent(path.toAbsolutePath(), p -> (PlainJavaFile)Wrappers.wrap(p.toFile()).as(AFile.class));
        if (resource instanceof PlainJavaFile) {
            return (PlainJavaFile)resource;
        }
        throw new IllegalArgumentException(path + " is not a file");
    }

    PlainJavaFolder folder(Path path) {
        PlainJavaResource resource = this.resources.computeIfAbsent(path.toAbsolutePath(), p -> (PlainJavaFolder)Wrappers.wrap(p.toFile()).as(AFolder.class));
        if (resource instanceof PlainJavaFolder) {
            return (PlainJavaFolder)resource;
        }
        throw new IllegalArgumentException(path + " is not a folder");
    }

    PlainJavaProject project(Path path) {
        Path absolutePath = path.toAbsolutePath();
        PlainJavaResource resource = this.resources.computeIfAbsent(absolutePath, p -> (PlainJavaProject)Wrappers.wrap(p.toFile()).as(AProject.class));
        if (resource instanceof PlainJavaProject) {
            return (PlainJavaProject)resource;
        }
        if (resource instanceof PlainJavaFolder) {
            PlainJavaProject project = (PlainJavaProject)Wrappers.wrap(((PlainJavaFolder)resource).directory()).as(AProject.class);
            this.resources.put(absolutePath, project);
            return project;
        }
        throw new IllegalArgumentException(path + " is not a project");
    }
}

