/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.nio.file.Path;
import org.eclipse.core.runtime.IPath;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.mapping.PathMapping;

public class PathUtil {
    private PathUtil() {
    }

    public static String segment(Path path, int index) {
        return path.getName(index).toString();
    }

    public static String lastSegment(Path path) {
        return path.getName(path.getNameCount() - 1).toString();
    }

    public static Path removeFirstSegments(Path path, int count) {
        return path.subpath(count, path.getNameCount());
    }

    public static Path fromOSString(String pathString) {
        return Path.of(pathString, new String[0]);
    }

    public static String getFileExtension(Path path) {
        Path filePath = path.getFileName();
        if (filePath == null) {
            return null;
        }
        String fileName = filePath.toString();
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static Path makeRelativeTo(Path path, Path base) {
        Path relativizedPath = base.relativize(path);
        if (relativizedPath.toString().isEmpty()) {
            return path;
        }
        return relativizedPath;
    }

    @CheckForNull
    public static String toPortableString(@CheckForNull Path path) {
        IPath eclipsePath = PathMapping.toEclipsePath(path);
        return eclipsePath == null ? null : eclipsePath.toPortableString();
    }

    public static boolean isAbsoluteInWorkspace(Path path) {
        return Abstractions.getWorkspace().getRoot().getProjects().stream().anyMatch(p -> path.startsWith(p.getWorkspaceRelativePath()));
    }
}

