/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction;

import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import org.faktorips.devtools.abstraction.AImplementationProvider;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.AVersion;
import org.faktorips.devtools.abstraction.AWorkspace;
import org.faktorips.devtools.abstraction.Wrappers;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.internal.OsgiImplementationProvider;

public final class Abstractions {
    private static final AImplementation IMPLEMENTATION = Abstractions.get();
    private static final boolean ECLIPSE_RUNNING = IMPLEMENTATION.isEclipse();

    private Abstractions() {
    }

    private static AImplementation get() {
        OsgiImplementationProvider osgiProvider = OsgiImplementationProvider.getInstance();
        if (osgiProvider != null) {
            return osgiProvider.get();
        }
        Optional<AImplementationProvider> implementationProvider = ServiceLoader.load(AImplementationProvider.class).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(AImplementationProvider::getPriority).reversed()).findFirst();
        return implementationProvider.orElseThrow(() -> new IpsException("No implementation provider found!")).get();
    }

    public static boolean isEclipseRunning() {
        return ECLIPSE_RUNNING;
    }

    public static AWorkspace getWorkspace() {
        return IMPLEMENTATION.getWorkspace();
    }

    public static Locale getLocale() {
        return IMPLEMENTATION.getLocale();
    }

    public static AVersion getVersion() {
        return IMPLEMENTATION.getVersion();
    }

    public static ALog getLog() {
        return IMPLEMENTATION.getLog();
    }

    public static String getImplementationId() {
        return IMPLEMENTATION.getId();
    }

    public static String getDebugOption(String option) {
        return IMPLEMENTATION.getDebugOption(option);
    }

    static Wrappers.WrapperBuilder getWrapperBuilder(Object original) {
        return IMPLEMENTATION.getWrapperBuilder(original);
    }

    public static interface AImplementation {
        public String getId();

        public String getDebugOption(String var1);

        public boolean isEclipse();

        public Wrappers.WrapperBuilder getWrapperBuilder(Object var1);

        public AWorkspace getWorkspace();

        public Locale getLocale();

        public AVersion getVersion();

        public ALog getLog();
    }
}

