/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.AAbstraction;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AMarker;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AWorkspace;

public interface AResource
extends AAbstraction,
Comparable<AResource> {
    public static final Comparator<AResource> COMPARING_BY_NAME = Comparator.comparing(AResource::getName);

    public String getName();

    public AResourceType getType();

    public boolean exists();

    public boolean isAccessible();

    public boolean isDerived();

    public void setDerived(boolean var1, @CheckForNull IProgressMonitor var2);

    @CheckForNull
    public AContainer getParent();

    @CheckForNull
    public AProject getProject();

    public AWorkspace getWorkspace();

    public Path getLocation();

    public Path getProjectRelativePath();

    public Path getWorkspaceRelativePath();

    public long getModificationStamp();

    public long getLocalTimeStamp();

    public void refreshLocal(AResourceTreeTraversalDepth var1, @CheckForNull IProgressMonitor var2);

    public boolean isSynchronized(AResourceTreeTraversalDepth var1);

    public void touch(IProgressMonitor var1);

    public Set<AMarker> findMarkers(String var1, boolean var2, AResourceTreeTraversalDepth var3);

    public AMarker createMarker(String var1);

    public void deleteMarkers(String var1, boolean var2, AResourceTreeTraversalDepth var3);

    public void delete(@CheckForNull IProgressMonitor var1);

    public void copy(Path var1, @CheckForNull IProgressMonitor var2);

    public void move(Path var1, @CheckForNull IProgressMonitor var2);

    @Override
    default public int compareTo(AResource o) {
        return COMPARING_BY_NAME.compare(this, o);
    }

    public static enum AResourceTreeTraversalDepth {
        RESOURCE_ONLY,
        RESOURCE_AND_DIRECT_MEMBERS,
        INFINITE;


        public AResourceTreeTraversalDepth decrement() {
            return switch (this) {
                case RESOURCE_AND_DIRECT_MEMBERS -> RESOURCE_ONLY;
                default -> this;
            };
        }
    }

    public static enum AResourceType {
        FILE,
        FOLDER,
        PROJECT,
        WORKSPACE;

    }
}

