/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.abstraction;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.faktorips.runtime.internal.IpsStringUtils;

public class AVersion
implements Comparable<AVersion> {
    public static final AVersion VERSION_ZERO = new AVersion(new long[]{0L}, "");
    private static final String DELIMITER = ".";
    private static final Pattern NUMERIC = Pattern.compile("\\d+");
    private static final String QUALIFIER = "qualifier";
    private final String versionString;
    private final long[] numericParts;
    private final String qualifier;

    private AVersion(long[] numericParts, String qualifier) {
        this.numericParts = numericParts;
        this.qualifier = qualifier;
        this.versionString = AVersion.toString(numericParts, qualifier);
    }

    private static final String toString(long[] numericParts, String qualifier) {
        Stream<String> parts = Arrays.stream(numericParts).mapToObj(Long::toString);
        if (IpsStringUtils.isNotBlank((String)qualifier)) {
            parts = Stream.concat(parts, Stream.of(qualifier));
        }
        return parts.collect(Collectors.joining(DELIMITER));
    }

    public static AVersion parse(String versionString) {
        Objects.requireNonNull(versionString, "versionString must not be null");
        if (IpsStringUtils.isBlank((String)versionString)) {
            return VERSION_ZERO;
        }
        LinkedList<Long> numericParts = new LinkedList<Long>();
        String qualifier = "";
        int lastIndex = 0;
        int index = AVersion.getNextDelimiterPosition(versionString, lastIndex);
        while (index > 0) {
            String part = versionString.substring(lastIndex, index);
            if (!NUMERIC.matcher(part).matches()) {
                qualifier = versionString.substring(lastIndex);
                break;
            }
            numericParts.add(Long.parseLong(part));
            lastIndex = index + 1;
            index = AVersion.getNextDelimiterPosition(versionString, lastIndex);
        }
        while (numericParts.size() > 1 && ((Long)numericParts.getLast()).equals(0L)) {
            numericParts.removeLast();
        }
        if (QUALIFIER.equals(qualifier)) {
            qualifier = "";
        }
        return new AVersion(numericParts.stream().mapToLong(i -> i).toArray(), qualifier);
    }

    private static int getNextDelimiterPosition(String versionString, int lastIndex) {
        if (lastIndex >= versionString.length()) {
            return -1;
        }
        int index = versionString.indexOf(46, lastIndex);
        return index < 0 ? versionString.length() : index;
    }

    @Override
    public int compareTo(AVersion o) {
        for (int i = 0; i < Math.min(this.numericParts.length, o.numericParts.length); ++i) {
            long diff = this.numericParts[i] - o.numericParts[i];
            if (diff == 0L) continue;
            return diff > Integer.MAX_VALUE ? Integer.MAX_VALUE : (diff < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)diff);
        }
        if (this.numericParts.length == o.numericParts.length) {
            return this.qualifier.compareTo(o.qualifier);
        }
        return this.numericParts.length - o.numericParts.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.numericParts);
        return 31 * result + this.qualifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AVersion other = (AVersion)obj;
        if (!Arrays.equals(this.numericParts, other.numericParts)) {
            return false;
        }
        return this.qualifier.equals(other.qualifier);
    }

    public String toString() {
        return this.versionString;
    }

    public AVersion majorMinor() {
        return this.numericParts.length >= 2 ? new AVersion(Arrays.copyOfRange(this.numericParts, 0, 2), "") : new AVersion(Arrays.copyOf(this.numericParts, this.numericParts.length), "");
    }

    public String getMajor() {
        return this.numericParts.length >= 1 ? Long.toString(this.numericParts[0]) : "0";
    }

    public String getMinor() {
        return this.numericParts.length >= 2 ? Long.toString(this.numericParts[1]) : "0";
    }
}

