/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.datatype.classtypes;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.faktorips.datatype.ValueClassNameDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.values.DateUtil;

public class GregorianCalendarDatatype
extends ValueClassNameDatatype {
    private final boolean timeInfoIncluded;

    public GregorianCalendarDatatype(String name, boolean timeInfoIncluded) {
        super(name);
        this.timeInfoIncluded = timeInfoIncluded;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Object getValue(String value) {
        if (this.timeInfoIncluded) {
            throw new RuntimeException("Not implemented yet");
        }
        if (IpsStringUtils.isEmpty((String)value)) {
            return null;
        }
        if (!DateUtil.isIsoDate((String)value)) {
            throw new IllegalArgumentException("Date value must have the format YYYY-MM-DD");
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "-");
            int year = Integer.parseInt(tokenizer.nextToken());
            int month = Integer.parseInt(tokenizer.nextToken());
            int date = Integer.parseInt(tokenizer.nextToken());
            return new GregorianCalendar(year, month - 1, date);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Can't parse " + value + " to a date!");
        }
    }

    @Override
    public boolean isParsable(String value) {
        return IpsStringUtils.isEmpty((String)value) || DateUtil.isIsoDate((String)value);
    }

    @Override
    public String valueToString(Object value) {
        if (this.timeInfoIncluded) {
            throw new RuntimeException("Not implemented yet");
        }
        GregorianCalendar calendar = (GregorianCalendar)value;
        if (calendar == null) {
            return "";
        }
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        return calendar.get(1) + "-" + (month < 10 ? "0" + month : "" + month) + "-" + (date < 10 ? "0" + date : "" + date);
    }

    @Override
    public boolean supportsCompare() {
        return true;
    }
}

