/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.codegen.CodeFragment;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.SingleConversionCg;
import org.faktorips.codegen.conversion.BigDecimalToDecimalCg;
import org.faktorips.codegen.conversion.BooleanToPrimitiveBooleanCg;
import org.faktorips.codegen.conversion.DecimalToBigDecimalCg;
import org.faktorips.codegen.conversion.DecimalToDoubleCg;
import org.faktorips.codegen.conversion.DoubleToDecimalCg;
import org.faktorips.codegen.conversion.IntegerToBigDecimalCg;
import org.faktorips.codegen.conversion.IntegerToDecimalCg;
import org.faktorips.codegen.conversion.IntegerToLongCg;
import org.faktorips.codegen.conversion.IntegerToPrimitiveIntCg;
import org.faktorips.codegen.conversion.LongToBigDecimalCg;
import org.faktorips.codegen.conversion.LongToDecimalCg;
import org.faktorips.codegen.conversion.LongToIntegerCg;
import org.faktorips.codegen.conversion.LongToPrimitiveLongCg;
import org.faktorips.codegen.conversion.PrimitiveBooleanToBooleanCg;
import org.faktorips.codegen.conversion.PrimitiveIntToBigDecimalCg;
import org.faktorips.codegen.conversion.PrimitiveIntToDecimalCg;
import org.faktorips.codegen.conversion.PrimitiveIntToIntegerCg;
import org.faktorips.codegen.conversion.PrimitiveIntToLongCg;
import org.faktorips.codegen.conversion.PrimitiveIntToPrimitiveLongCg;
import org.faktorips.codegen.conversion.PrimitiveLongToBigDecimalCg;
import org.faktorips.codegen.conversion.PrimitiveLongToLongCg;
import org.faktorips.codegen.conversion.PrimitiveLongToPrimitiveIntCg;
import org.faktorips.codegen.conversion.joda.LocalDateTimeToGregorianCalendarCg;
import org.faktorips.codegen.conversion.joda.LocalDateToGregorianCalendarCg;
import org.faktorips.datatype.AnyDatatype;
import org.faktorips.datatype.ConversionMatrix;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ListOfTypeDatatype;

public class ConversionCodeGenerator<T extends CodeFragment>
implements ConversionMatrix {
    private FromToConversionMap<T> fromToConversionMap = new FromToConversionMap();

    public static final ConversionCodeGenerator<JavaCodeFragment> getDefault() {
        ConversionCodeGenerator<JavaCodeFragment> ccg = new ConversionCodeGenerator<JavaCodeFragment>();
        ccg.add(new BooleanToPrimitiveBooleanCg());
        ccg.add(new IntegerToBigDecimalCg());
        ccg.add(new IntegerToDecimalCg());
        ccg.add(new IntegerToPrimitiveIntCg());
        ccg.add(new IntegerToLongCg());
        ccg.add(new LongToBigDecimalCg());
        ccg.add(new LongToDecimalCg());
        ccg.add(new LongToPrimitiveLongCg());
        ccg.add(new LongToIntegerCg());
        ccg.add(new PrimitiveBooleanToBooleanCg());
        ccg.add(new PrimitiveIntToBigDecimalCg());
        ccg.add(new PrimitiveIntToDecimalCg());
        ccg.add(new PrimitiveIntToIntegerCg());
        ccg.add(new PrimitiveIntToLongCg());
        ccg.add(new PrimitiveIntToPrimitiveLongCg());
        ccg.add(new PrimitiveLongToBigDecimalCg());
        ccg.add(new PrimitiveLongToLongCg());
        ccg.add(new PrimitiveLongToPrimitiveIntCg());
        ccg.add(new BigDecimalToDecimalCg());
        ccg.add(new DecimalToBigDecimalCg());
        ccg.add(new DoubleToDecimalCg());
        ccg.add(new DecimalToDoubleCg());
        ccg.add(new LocalDateToGregorianCalendarCg());
        ccg.add(new LocalDateTimeToGregorianCalendarCg());
        return ccg;
    }

    public void add(SingleConversionCg<T> conversion) {
        this.addConversionToMap(conversion);
    }

    private void addConversionToMap(SingleConversionCg<T> conversion) {
        this.fromToConversionMap.add(conversion);
    }

    @Override
    public boolean canConvert(Datatype from, Datatype to) {
        return this.isNoConversionNeccessary(from, to) || this.isListToListConversionAvailable(from, to) || this.isSingleConversionAvailable(from, to);
    }

    private boolean isEqual(Datatype from, Datatype to) {
        return from.equals(to);
    }

    private boolean isNoConversionNeccessary(Datatype from, Datatype to) {
        return this.isEqual(from, to) || this.isAnyDatatype(to);
    }

    private boolean isAnyDatatype(Datatype to) {
        return to instanceof AnyDatatype;
    }

    private boolean isSingleConversionAvailable(Datatype from, Datatype to) {
        return this.getSingleConversionCode(from, to) != null;
    }

    private boolean isListToListConversionAvailable(Datatype from, Datatype to) {
        return this.isListToListConversion(from, to) && this.isAnyDatatype(this.getBasicDatatype(to));
    }

    private boolean isListToListConversion(Datatype from, Datatype to) {
        return this.isInstanceListOfTypeDatatype(from) && this.isInstanceListOfTypeDatatype(to);
    }

    private boolean isInstanceListOfTypeDatatype(Datatype datatype) {
        return datatype instanceof ListOfTypeDatatype;
    }

    private Datatype getBasicDatatype(Datatype datatype) {
        return ((ListOfTypeDatatype)datatype).getBasicDatatype();
    }

    public T getConversionCode(Datatype from, Datatype to, T fromValue) {
        if (this.nullCheck(from, to)) {
            return null;
        }
        if (this.isNoConversionNeccessary(from, to) || this.isListToListConversionAvailable(from, to)) {
            return fromValue;
        }
        if (this.isSingleConversionAvailable(from, to)) {
            return this.getSingleConversionCode(from, to).getConversionCode(fromValue);
        }
        return null;
    }

    private boolean nullCheck(Datatype from, Datatype to) {
        return from == null || to == null;
    }

    private SingleConversionCg<T> getSingleConversionCode(Datatype from, Datatype to) {
        SingleConversionCg<T> singleConversionCg = this.fromToConversionMap.get(from, to);
        if (singleConversionCg == null) {
            singleConversionCg = this.fromToConversionMap.get(AnyDatatype.INSTANCE, to);
        }
        return singleConversionCg;
    }

    private static class FromToConversionMap<T extends CodeFragment> {
        private final Map<Datatype, Map<Datatype, SingleConversionCg<T>>> internalMap = new ConcurrentHashMap<Datatype, Map<Datatype, SingleConversionCg<T>>>();

        private FromToConversionMap() {
        }

        public SingleConversionCg<T> get(Datatype from, Datatype to) {
            if (this.nullCheck(from, to)) {
                return null;
            }
            return this.getMapValueOfFromDatatype(from).get(to);
        }

        public void add(SingleConversionCg<T> singleConversionCg) {
            Datatype from = singleConversionCg.getFrom();
            Datatype to = singleConversionCg.getTo();
            Map<Datatype, SingleConversionCg<T>> innerMap = this.getMapValueOfFromDatatype(from);
            innerMap.put(to, singleConversionCg);
        }

        private Map<Datatype, SingleConversionCg<T>> getMapValueOfFromDatatype(Datatype from) {
            return this.internalMap.computeIfAbsent(from, $ -> new ConcurrentHashMap());
        }

        private boolean nullCheck(Datatype from, Datatype to) {
            return from == null || to == null;
        }
    }
}

