/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.codegen.dthelpers;

import org.faktorips.codegen.DatatypeHelper;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.codegen.dthelpers.AbstractPrimitiveDatatypeHelper;
import org.faktorips.datatype.PrimitiveBooleanDatatype;

public class PrimitiveBooleanHelper
extends AbstractPrimitiveDatatypeHelper {
    public PrimitiveBooleanHelper() {
    }

    public PrimitiveBooleanHelper(PrimitiveBooleanDatatype datatype) {
        super(datatype);
    }

    @Override
    public DatatypeHelper getWrapperTypeHelper() {
        return DatatypeHelper.BOOLEAN;
    }

    @Override
    public String getJavaClassName() {
        return Boolean.TYPE.getName();
    }

    @Override
    public JavaCodeFragment newInstance(String value) {
        boolean booleanValue = Boolean.parseBoolean(value);
        if (booleanValue) {
            return new JavaCodeFragment("true");
        }
        return new JavaCodeFragment("false");
    }

    @Override
    public JavaCodeFragment toWrapper(JavaCodeFragment expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.appendClassName(Boolean.class);
        fragment.append(".valueOf(");
        fragment.append(expression);
        fragment.append(')');
        return fragment;
    }

    @Override
    protected JavaCodeFragment valueOfExpression(String expression) {
        JavaCodeFragment fragment = new JavaCodeFragment();
        fragment.append("Boolean.valueOf(" + expression + ").booleanValue()");
        return fragment;
    }
}

